package zio.aws.ses.model
import scala.jdk.CollectionConverters._
sealed trait EventType {
  def unwrap: software.amazon.awssdk.services.ses.model.EventType
}
object EventType {
  def wrap(
      value: software.amazon.awssdk.services.ses.model.EventType
  ): zio.aws.ses.model.EventType = value match {
    case software.amazon.awssdk.services.ses.model.EventType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ses.model.EventType.SEND =>
      val r = send
      r
    case software.amazon.awssdk.services.ses.model.EventType.REJECT =>
      val r = reject
      r
    case software.amazon.awssdk.services.ses.model.EventType.BOUNCE =>
      val r = bounce
      r
    case software.amazon.awssdk.services.ses.model.EventType.COMPLAINT =>
      val r = complaint
      r
    case software.amazon.awssdk.services.ses.model.EventType.DELIVERY =>
      val r = delivery
      r
    case software.amazon.awssdk.services.ses.model.EventType.OPEN =>
      val r = open
      r
    case software.amazon.awssdk.services.ses.model.EventType.CLICK =>
      val r = click
      r
    case software.amazon.awssdk.services.ses.model.EventType.RENDERING_FAILURE =>
      val r = renderingFailure
      r
  }
  case object unknownToSdkVersion extends zio.aws.ses.model.EventType {
    override def unwrap: software.amazon.awssdk.services.ses.model.EventType =
      software.amazon.awssdk.services.ses.model.EventType.UNKNOWN_TO_SDK_VERSION
  }
  case object send extends zio.aws.ses.model.EventType {
    override def unwrap: software.amazon.awssdk.services.ses.model.EventType =
      software.amazon.awssdk.services.ses.model.EventType.SEND
  }
  case object reject extends zio.aws.ses.model.EventType {
    override def unwrap: software.amazon.awssdk.services.ses.model.EventType =
      software.amazon.awssdk.services.ses.model.EventType.REJECT
  }
  case object bounce extends zio.aws.ses.model.EventType {
    override def unwrap: software.amazon.awssdk.services.ses.model.EventType =
      software.amazon.awssdk.services.ses.model.EventType.BOUNCE
  }
  case object complaint extends zio.aws.ses.model.EventType {
    override def unwrap: software.amazon.awssdk.services.ses.model.EventType =
      software.amazon.awssdk.services.ses.model.EventType.COMPLAINT
  }
  case object delivery extends zio.aws.ses.model.EventType {
    override def unwrap: software.amazon.awssdk.services.ses.model.EventType =
      software.amazon.awssdk.services.ses.model.EventType.DELIVERY
  }
  case object open extends zio.aws.ses.model.EventType {
    override def unwrap: software.amazon.awssdk.services.ses.model.EventType =
      software.amazon.awssdk.services.ses.model.EventType.OPEN
  }
  case object click extends zio.aws.ses.model.EventType {
    override def unwrap: software.amazon.awssdk.services.ses.model.EventType =
      software.amazon.awssdk.services.ses.model.EventType.CLICK
  }
  case object renderingFailure extends zio.aws.ses.model.EventType {
    override def unwrap: software.amazon.awssdk.services.ses.model.EventType =
      software.amazon.awssdk.services.ses.model.EventType.RENDERING_FAILURE
  }
}
