package zio.aws.ses.model
import zio.aws.ses.model.primitives.Enabled
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetAccountSendingEnabledResponse(
    enabled: Optional[Enabled] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.GetAccountSendingEnabledResponse = {
    import GetAccountSendingEnabledResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.GetAccountSendingEnabledResponse
      .builder()
      .optionallyWith(
        enabled.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.GetAccountSendingEnabledResponse.ReadOnly =
    zio.aws.ses.model.GetAccountSendingEnabledResponse.wrap(buildAwsValue())
}
object GetAccountSendingEnabledResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.GetAccountSendingEnabledResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.GetAccountSendingEnabledResponse =
      zio.aws.ses.model
        .GetAccountSendingEnabledResponse(enabled.map(value => value))
    def enabled: Optional[Enabled]
    def getEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.GetAccountSendingEnabledResponse
  ) extends zio.aws.ses.model.GetAccountSendingEnabledResponse.ReadOnly {
    override val enabled: Optional[Enabled] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => zio.aws.ses.model.primitives.Enabled(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.GetAccountSendingEnabledResponse
  ): zio.aws.ses.model.GetAccountSendingEnabledResponse.ReadOnly = new Wrapper(
    impl
  )
}
