package zio.aws.ses.model
import zio.aws.ses.model.primitives.AmazonResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LambdaAction(
    topicArn: Optional[AmazonResourceName] = Optional.Absent,
    functionArn: AmazonResourceName,
    invocationType: Optional[zio.aws.ses.model.InvocationType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.LambdaAction = {
    import LambdaAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.LambdaAction
      .builder()
      .optionallyWith(
        topicArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.topicArn)
      .functionArn(AmazonResourceName.unwrap(functionArn): java.lang.String)
      .optionallyWith(invocationType.map(value => value.unwrap))(
        _.invocationType
      )
      .build()
  }
  def asReadOnly: zio.aws.ses.model.LambdaAction.ReadOnly =
    zio.aws.ses.model.LambdaAction.wrap(buildAwsValue())
}
object LambdaAction {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ses.model.LambdaAction] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.LambdaAction =
      zio.aws.ses.model.LambdaAction(
        topicArn.map(value => value),
        functionArn,
        invocationType.map(value => value)
      )
    def topicArn: Optional[AmazonResourceName]
    def functionArn: AmazonResourceName
    def invocationType: Optional[zio.aws.ses.model.InvocationType]
    def getTopicArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("topicArn", topicArn)
    def getFunctionArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(functionArn)
    def getInvocationType
        : ZIO[Any, AwsError, zio.aws.ses.model.InvocationType] =
      AwsError.unwrapOptionField("invocationType", invocationType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.LambdaAction
  ) extends zio.aws.ses.model.LambdaAction.ReadOnly {
    override val topicArn: Optional[AmazonResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.topicArn())
      .map(value => zio.aws.ses.model.primitives.AmazonResourceName(value))
    override val functionArn: AmazonResourceName =
      zio.aws.ses.model.primitives.AmazonResourceName(impl.functionArn())
    override val invocationType: Optional[zio.aws.ses.model.InvocationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.invocationType())
        .map(value => zio.aws.ses.model.InvocationType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.LambdaAction
  ): zio.aws.ses.model.LambdaAction.ReadOnly = new Wrapper(impl)
}
