package zio.aws.ses.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ses.model.primitives.{ArrivalDate, ReportingMta}
import scala.jdk.CollectionConverters._
final case class MessageDsn(
    reportingMta: ReportingMta,
    arrivalDate: Optional[ArrivalDate] = Optional.Absent,
    extensionFields: Optional[Iterable[zio.aws.ses.model.ExtensionField]] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ses.model.MessageDsn = {
    import MessageDsn.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.MessageDsn
      .builder()
      .reportingMta(ReportingMta.unwrap(reportingMta): java.lang.String)
      .optionallyWith(
        arrivalDate.map(value => ArrivalDate.unwrap(value): Instant)
      )(_.arrivalDate)
      .optionallyWith(
        extensionFields.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.extensionFields)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.MessageDsn.ReadOnly =
    zio.aws.ses.model.MessageDsn.wrap(buildAwsValue())
}
object MessageDsn {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ses.model.MessageDsn] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.MessageDsn = zio.aws.ses.model.MessageDsn(
      reportingMta,
      arrivalDate.map(value => value),
      extensionFields.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def reportingMta: ReportingMta
    def arrivalDate: Optional[ArrivalDate]
    def extensionFields
        : Optional[List[zio.aws.ses.model.ExtensionField.ReadOnly]]
    def getReportingMta: ZIO[Any, Nothing, ReportingMta] =
      ZIO.succeed(reportingMta)
    def getArrivalDate: ZIO[Any, AwsError, ArrivalDate] =
      AwsError.unwrapOptionField("arrivalDate", arrivalDate)
    def getExtensionFields
        : ZIO[Any, AwsError, List[zio.aws.ses.model.ExtensionField.ReadOnly]] =
      AwsError.unwrapOptionField("extensionFields", extensionFields)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.MessageDsn
  ) extends zio.aws.ses.model.MessageDsn.ReadOnly {
    override val reportingMta: ReportingMta =
      zio.aws.ses.model.primitives.ReportingMta(impl.reportingMta())
    override val arrivalDate: Optional[ArrivalDate] = zio.aws.core.internal
      .optionalFromNullable(impl.arrivalDate())
      .map(value => zio.aws.ses.model.primitives.ArrivalDate(value))
    override val extensionFields
        : Optional[List[zio.aws.ses.model.ExtensionField.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.extensionFields())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ses.model.ExtensionField.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.MessageDsn
  ): zio.aws.ses.model.MessageDsn.ReadOnly = new Wrapper(impl)
}
