package zio.aws.ses.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ReceiptAction(
    s3Action: Optional[zio.aws.ses.model.S3Action] = Optional.Absent,
    bounceAction: Optional[zio.aws.ses.model.BounceAction] = Optional.Absent,
    workmailAction: Optional[zio.aws.ses.model.WorkmailAction] =
      Optional.Absent,
    lambdaAction: Optional[zio.aws.ses.model.LambdaAction] = Optional.Absent,
    stopAction: Optional[zio.aws.ses.model.StopAction] = Optional.Absent,
    addHeaderAction: Optional[zio.aws.ses.model.AddHeaderAction] =
      Optional.Absent,
    snsAction: Optional[zio.aws.ses.model.SNSAction] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.ReceiptAction = {
    import ReceiptAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.ReceiptAction
      .builder()
      .optionallyWith(s3Action.map(value => value.buildAwsValue()))(_.s3Action)
      .optionallyWith(bounceAction.map(value => value.buildAwsValue()))(
        _.bounceAction
      )
      .optionallyWith(workmailAction.map(value => value.buildAwsValue()))(
        _.workmailAction
      )
      .optionallyWith(lambdaAction.map(value => value.buildAwsValue()))(
        _.lambdaAction
      )
      .optionallyWith(stopAction.map(value => value.buildAwsValue()))(
        _.stopAction
      )
      .optionallyWith(addHeaderAction.map(value => value.buildAwsValue()))(
        _.addHeaderAction
      )
      .optionallyWith(snsAction.map(value => value.buildAwsValue()))(
        _.snsAction
      )
      .build()
  }
  def asReadOnly: zio.aws.ses.model.ReceiptAction.ReadOnly =
    zio.aws.ses.model.ReceiptAction.wrap(buildAwsValue())
}
object ReceiptAction {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ses.model.ReceiptAction] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.ReceiptAction =
      zio.aws.ses.model.ReceiptAction(
        s3Action.map(value => value.asEditable),
        bounceAction.map(value => value.asEditable),
        workmailAction.map(value => value.asEditable),
        lambdaAction.map(value => value.asEditable),
        stopAction.map(value => value.asEditable),
        addHeaderAction.map(value => value.asEditable),
        snsAction.map(value => value.asEditable)
      )
    def s3Action: Optional[zio.aws.ses.model.S3Action.ReadOnly]
    def bounceAction: Optional[zio.aws.ses.model.BounceAction.ReadOnly]
    def workmailAction: Optional[zio.aws.ses.model.WorkmailAction.ReadOnly]
    def lambdaAction: Optional[zio.aws.ses.model.LambdaAction.ReadOnly]
    def stopAction: Optional[zio.aws.ses.model.StopAction.ReadOnly]
    def addHeaderAction: Optional[zio.aws.ses.model.AddHeaderAction.ReadOnly]
    def snsAction: Optional[zio.aws.ses.model.SNSAction.ReadOnly]
    def getS3Action: ZIO[Any, AwsError, zio.aws.ses.model.S3Action.ReadOnly] =
      AwsError.unwrapOptionField("s3Action", s3Action)
    def getBounceAction
        : ZIO[Any, AwsError, zio.aws.ses.model.BounceAction.ReadOnly] =
      AwsError.unwrapOptionField("bounceAction", bounceAction)
    def getWorkmailAction
        : ZIO[Any, AwsError, zio.aws.ses.model.WorkmailAction.ReadOnly] =
      AwsError.unwrapOptionField("workmailAction", workmailAction)
    def getLambdaAction
        : ZIO[Any, AwsError, zio.aws.ses.model.LambdaAction.ReadOnly] =
      AwsError.unwrapOptionField("lambdaAction", lambdaAction)
    def getStopAction
        : ZIO[Any, AwsError, zio.aws.ses.model.StopAction.ReadOnly] =
      AwsError.unwrapOptionField("stopAction", stopAction)
    def getAddHeaderAction
        : ZIO[Any, AwsError, zio.aws.ses.model.AddHeaderAction.ReadOnly] =
      AwsError.unwrapOptionField("addHeaderAction", addHeaderAction)
    def getSnsAction: ZIO[Any, AwsError, zio.aws.ses.model.SNSAction.ReadOnly] =
      AwsError.unwrapOptionField("snsAction", snsAction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.ReceiptAction
  ) extends zio.aws.ses.model.ReceiptAction.ReadOnly {
    override val s3Action: Optional[zio.aws.ses.model.S3Action.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Action())
        .map(value => zio.aws.ses.model.S3Action.wrap(value))
    override val bounceAction
        : Optional[zio.aws.ses.model.BounceAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bounceAction())
        .map(value => zio.aws.ses.model.BounceAction.wrap(value))
    override val workmailAction
        : Optional[zio.aws.ses.model.WorkmailAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workmailAction())
        .map(value => zio.aws.ses.model.WorkmailAction.wrap(value))
    override val lambdaAction
        : Optional[zio.aws.ses.model.LambdaAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lambdaAction())
        .map(value => zio.aws.ses.model.LambdaAction.wrap(value))
    override val stopAction: Optional[zio.aws.ses.model.StopAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stopAction())
        .map(value => zio.aws.ses.model.StopAction.wrap(value))
    override val addHeaderAction
        : Optional[zio.aws.ses.model.AddHeaderAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.addHeaderAction())
        .map(value => zio.aws.ses.model.AddHeaderAction.wrap(value))
    override val snsAction: Optional[zio.aws.ses.model.SNSAction.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snsAction())
        .map(value => zio.aws.ses.model.SNSAction.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.ReceiptAction
  ): zio.aws.ses.model.ReceiptAction.ReadOnly = new Wrapper(impl)
}
