package zio.aws.ses.model
import zio.aws.ses.model.primitives.ReceiptFilterName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ReceiptFilter(
    name: ReceiptFilterName,
    ipFilter: zio.aws.ses.model.ReceiptIpFilter
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.ReceiptFilter = {
    import ReceiptFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.ReceiptFilter
      .builder()
      .name(ReceiptFilterName.unwrap(name): java.lang.String)
      .ipFilter(ipFilter.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.ses.model.ReceiptFilter.ReadOnly =
    zio.aws.ses.model.ReceiptFilter.wrap(buildAwsValue())
}
object ReceiptFilter {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ses.model.ReceiptFilter] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.ReceiptFilter =
      zio.aws.ses.model.ReceiptFilter(name, ipFilter.asEditable)
    def name: ReceiptFilterName
    def ipFilter: zio.aws.ses.model.ReceiptIpFilter.ReadOnly
    def getName: ZIO[Any, Nothing, ReceiptFilterName] = ZIO.succeed(name)
    def getIpFilter
        : ZIO[Any, Nothing, zio.aws.ses.model.ReceiptIpFilter.ReadOnly] =
      ZIO.succeed(ipFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.ReceiptFilter
  ) extends zio.aws.ses.model.ReceiptFilter.ReadOnly {
    override val name: ReceiptFilterName =
      zio.aws.ses.model.primitives.ReceiptFilterName(impl.name())
    override val ipFilter: zio.aws.ses.model.ReceiptIpFilter.ReadOnly =
      zio.aws.ses.model.ReceiptIpFilter.wrap(impl.ipFilter())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.ReceiptFilter
  ): zio.aws.ses.model.ReceiptFilter.ReadOnly = new Wrapper(impl)
}
