package zio.aws.ses.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ses.model.primitives.{
  LastAttemptDate,
  Address,
  DsnStatus,
  DiagnosticCode,
  RemoteMta
}
import scala.jdk.CollectionConverters._
final case class RecipientDsnFields(
    finalRecipient: Optional[Address] = Optional.Absent,
    action: zio.aws.ses.model.DsnAction,
    remoteMta: Optional[RemoteMta] = Optional.Absent,
    status: DsnStatus,
    diagnosticCode: Optional[DiagnosticCode] = Optional.Absent,
    lastAttemptDate: Optional[LastAttemptDate] = Optional.Absent,
    extensionFields: Optional[Iterable[zio.aws.ses.model.ExtensionField]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.RecipientDsnFields = {
    import RecipientDsnFields.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.RecipientDsnFields
      .builder()
      .optionallyWith(
        finalRecipient.map(value => Address.unwrap(value): java.lang.String)
      )(_.finalRecipient)
      .action(action.unwrap)
      .optionallyWith(
        remoteMta.map(value => RemoteMta.unwrap(value): java.lang.String)
      )(_.remoteMta)
      .status(DsnStatus.unwrap(status): java.lang.String)
      .optionallyWith(
        diagnosticCode.map(value =>
          DiagnosticCode.unwrap(value): java.lang.String
        )
      )(_.diagnosticCode)
      .optionallyWith(
        lastAttemptDate.map(value => LastAttemptDate.unwrap(value): Instant)
      )(_.lastAttemptDate)
      .optionallyWith(
        extensionFields.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.extensionFields)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.RecipientDsnFields.ReadOnly =
    zio.aws.ses.model.RecipientDsnFields.wrap(buildAwsValue())
}
object RecipientDsnFields {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.RecipientDsnFields
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.RecipientDsnFields =
      zio.aws.ses.model.RecipientDsnFields(
        finalRecipient.map(value => value),
        action,
        remoteMta.map(value => value),
        status,
        diagnosticCode.map(value => value),
        lastAttemptDate.map(value => value),
        extensionFields.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def finalRecipient: Optional[Address]
    def action: zio.aws.ses.model.DsnAction
    def remoteMta: Optional[RemoteMta]
    def status: DsnStatus
    def diagnosticCode: Optional[DiagnosticCode]
    def lastAttemptDate: Optional[LastAttemptDate]
    def extensionFields
        : Optional[List[zio.aws.ses.model.ExtensionField.ReadOnly]]
    def getFinalRecipient: ZIO[Any, AwsError, Address] =
      AwsError.unwrapOptionField("finalRecipient", finalRecipient)
    def getAction: ZIO[Any, Nothing, zio.aws.ses.model.DsnAction] =
      ZIO.succeed(action)
    def getRemoteMta: ZIO[Any, AwsError, RemoteMta] =
      AwsError.unwrapOptionField("remoteMta", remoteMta)
    def getStatus: ZIO[Any, Nothing, DsnStatus] = ZIO.succeed(status)
    def getDiagnosticCode: ZIO[Any, AwsError, DiagnosticCode] =
      AwsError.unwrapOptionField("diagnosticCode", diagnosticCode)
    def getLastAttemptDate: ZIO[Any, AwsError, LastAttemptDate] =
      AwsError.unwrapOptionField("lastAttemptDate", lastAttemptDate)
    def getExtensionFields
        : ZIO[Any, AwsError, List[zio.aws.ses.model.ExtensionField.ReadOnly]] =
      AwsError.unwrapOptionField("extensionFields", extensionFields)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.RecipientDsnFields
  ) extends zio.aws.ses.model.RecipientDsnFields.ReadOnly {
    override val finalRecipient: Optional[Address] = zio.aws.core.internal
      .optionalFromNullable(impl.finalRecipient())
      .map(value => zio.aws.ses.model.primitives.Address(value))
    override val action: zio.aws.ses.model.DsnAction =
      zio.aws.ses.model.DsnAction.wrap(impl.action())
    override val remoteMta: Optional[RemoteMta] = zio.aws.core.internal
      .optionalFromNullable(impl.remoteMta())
      .map(value => zio.aws.ses.model.primitives.RemoteMta(value))
    override val status: DsnStatus =
      zio.aws.ses.model.primitives.DsnStatus(impl.status())
    override val diagnosticCode: Optional[DiagnosticCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.diagnosticCode())
        .map(value => zio.aws.ses.model.primitives.DiagnosticCode(value))
    override val lastAttemptDate: Optional[LastAttemptDate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastAttemptDate())
        .map(value => zio.aws.ses.model.primitives.LastAttemptDate(value))
    override val extensionFields
        : Optional[List[zio.aws.ses.model.ExtensionField.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.extensionFields())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ses.model.ExtensionField.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.RecipientDsnFields
  ): zio.aws.ses.model.RecipientDsnFields.ReadOnly = new Wrapper(impl)
}
