package zio.aws.ses.model
import zio.aws.ses.model.primitives.AmazonResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SNSDestination(topicARN: AmazonResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.SNSDestination = {
    import SNSDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.SNSDestination
      .builder()
      .topicARN(AmazonResourceName.unwrap(topicARN): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.SNSDestination.ReadOnly =
    zio.aws.ses.model.SNSDestination.wrap(buildAwsValue())
}
object SNSDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.SNSDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.SNSDestination =
      zio.aws.ses.model.SNSDestination(topicARN)
    def topicARN: AmazonResourceName
    def getTopicARN: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(topicARN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.SNSDestination
  ) extends zio.aws.ses.model.SNSDestination.ReadOnly {
    override val topicARN: AmazonResourceName =
      zio.aws.ses.model.primitives.AmazonResourceName(impl.topicARN())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.SNSDestination
  ): zio.aws.ses.model.SNSDestination.ReadOnly = new Wrapper(impl)
}
