package zio.aws.ses.model
import zio.aws.ses.model.primitives.{
  ConfigurationSetName,
  TemplateName,
  Address
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SendCustomVerificationEmailRequest(
    emailAddress: Address,
    templateName: TemplateName,
    configurationSetName: Optional[ConfigurationSetName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.SendCustomVerificationEmailRequest = {
    import SendCustomVerificationEmailRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.SendCustomVerificationEmailRequest
      .builder()
      .emailAddress(Address.unwrap(emailAddress): java.lang.String)
      .templateName(TemplateName.unwrap(templateName): java.lang.String)
      .optionallyWith(
        configurationSetName.map(value =>
          ConfigurationSetName.unwrap(value): java.lang.String
        )
      )(_.configurationSetName)
      .build()
  }
  def asReadOnly
      : zio.aws.ses.model.SendCustomVerificationEmailRequest.ReadOnly =
    zio.aws.ses.model.SendCustomVerificationEmailRequest.wrap(buildAwsValue())
}
object SendCustomVerificationEmailRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.SendCustomVerificationEmailRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.SendCustomVerificationEmailRequest =
      zio.aws.ses.model.SendCustomVerificationEmailRequest(
        emailAddress,
        templateName,
        configurationSetName.map(value => value)
      )
    def emailAddress: Address
    def templateName: TemplateName
    def configurationSetName: Optional[ConfigurationSetName]
    def getEmailAddress: ZIO[Any, Nothing, Address] = ZIO.succeed(emailAddress)
    def getTemplateName: ZIO[Any, Nothing, TemplateName] =
      ZIO.succeed(templateName)
    def getConfigurationSetName: ZIO[Any, AwsError, ConfigurationSetName] =
      AwsError.unwrapOptionField("configurationSetName", configurationSetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.SendCustomVerificationEmailRequest
  ) extends zio.aws.ses.model.SendCustomVerificationEmailRequest.ReadOnly {
    override val emailAddress: Address =
      zio.aws.ses.model.primitives.Address(impl.emailAddress())
    override val templateName: TemplateName =
      zio.aws.ses.model.primitives.TemplateName(impl.templateName())
    override val configurationSetName: Optional[ConfigurationSetName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurationSetName())
        .map(value => zio.aws.ses.model.primitives.ConfigurationSetName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.SendCustomVerificationEmailRequest
  ): zio.aws.ses.model.SendCustomVerificationEmailRequest.ReadOnly =
    new Wrapper(impl)
}
