package zio.aws.ses.model
import zio.aws.ses.model.primitives.MessageId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SendCustomVerificationEmailResponse(
    messageId: Optional[MessageId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.SendCustomVerificationEmailResponse = {
    import SendCustomVerificationEmailResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.SendCustomVerificationEmailResponse
      .builder()
      .optionallyWith(
        messageId.map(value => MessageId.unwrap(value): java.lang.String)
      )(_.messageId)
      .build()
  }
  def asReadOnly
      : zio.aws.ses.model.SendCustomVerificationEmailResponse.ReadOnly =
    zio.aws.ses.model.SendCustomVerificationEmailResponse.wrap(buildAwsValue())
}
object SendCustomVerificationEmailResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.SendCustomVerificationEmailResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.SendCustomVerificationEmailResponse =
      zio.aws.ses.model
        .SendCustomVerificationEmailResponse(messageId.map(value => value))
    def messageId: Optional[MessageId]
    def getMessageId: ZIO[Any, AwsError, MessageId] =
      AwsError.unwrapOptionField("messageId", messageId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.SendCustomVerificationEmailResponse
  ) extends zio.aws.ses.model.SendCustomVerificationEmailResponse.ReadOnly {
    override val messageId: Optional[MessageId] = zio.aws.core.internal
      .optionalFromNullable(impl.messageId())
      .map(value => zio.aws.ses.model.primitives.MessageId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.SendCustomVerificationEmailResponse
  ): zio.aws.ses.model.SendCustomVerificationEmailResponse.ReadOnly =
    new Wrapper(impl)
}
