package zio.aws.ses.model
import zio.aws.ses.model.primitives.MessageId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SendTemplatedEmailResponse(messageId: MessageId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.SendTemplatedEmailResponse = {
    import SendTemplatedEmailResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.SendTemplatedEmailResponse
      .builder()
      .messageId(MessageId.unwrap(messageId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.SendTemplatedEmailResponse.ReadOnly =
    zio.aws.ses.model.SendTemplatedEmailResponse.wrap(buildAwsValue())
}
object SendTemplatedEmailResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.SendTemplatedEmailResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.SendTemplatedEmailResponse =
      zio.aws.ses.model.SendTemplatedEmailResponse(messageId)
    def messageId: MessageId
    def getMessageId: ZIO[Any, Nothing, MessageId] = ZIO.succeed(messageId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.SendTemplatedEmailResponse
  ) extends zio.aws.ses.model.SendTemplatedEmailResponse.ReadOnly {
    override val messageId: MessageId =
      zio.aws.ses.model.primitives.MessageId(impl.messageId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.SendTemplatedEmailResponse
  ): zio.aws.ses.model.SendTemplatedEmailResponse.ReadOnly = new Wrapper(impl)
}
