package zio.aws.ses.model
import zio.aws.ses.model.primitives.{NotificationTopic, Identity}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SetIdentityNotificationTopicRequest(
    identity: Identity,
    notificationType: zio.aws.ses.model.NotificationType,
    snsTopic: Optional[NotificationTopic] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.SetIdentityNotificationTopicRequest = {
    import SetIdentityNotificationTopicRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.SetIdentityNotificationTopicRequest
      .builder()
      .identity(Identity.unwrap(identity): java.lang.String)
      .notificationType(notificationType.unwrap)
      .optionallyWith(
        snsTopic.map(value => NotificationTopic.unwrap(value): java.lang.String)
      )(_.snsTopic)
      .build()
  }
  def asReadOnly
      : zio.aws.ses.model.SetIdentityNotificationTopicRequest.ReadOnly =
    zio.aws.ses.model.SetIdentityNotificationTopicRequest.wrap(buildAwsValue())
}
object SetIdentityNotificationTopicRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.SetIdentityNotificationTopicRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.SetIdentityNotificationTopicRequest =
      zio.aws.ses.model.SetIdentityNotificationTopicRequest(
        identity,
        notificationType,
        snsTopic.map(value => value)
      )
    def identity: Identity
    def notificationType: zio.aws.ses.model.NotificationType
    def snsTopic: Optional[NotificationTopic]
    def getIdentity: ZIO[Any, Nothing, Identity] = ZIO.succeed(identity)
    def getNotificationType
        : ZIO[Any, Nothing, zio.aws.ses.model.NotificationType] =
      ZIO.succeed(notificationType)
    def getSnsTopic: ZIO[Any, AwsError, NotificationTopic] =
      AwsError.unwrapOptionField("snsTopic", snsTopic)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.SetIdentityNotificationTopicRequest
  ) extends zio.aws.ses.model.SetIdentityNotificationTopicRequest.ReadOnly {
    override val identity: Identity =
      zio.aws.ses.model.primitives.Identity(impl.identity())
    override val notificationType: zio.aws.ses.model.NotificationType =
      zio.aws.ses.model.NotificationType.wrap(impl.notificationType())
    override val snsTopic: Optional[NotificationTopic] = zio.aws.core.internal
      .optionalFromNullable(impl.snsTopic())
      .map(value => zio.aws.ses.model.primitives.NotificationTopic(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.SetIdentityNotificationTopicRequest
  ): zio.aws.ses.model.SetIdentityNotificationTopicRequest.ReadOnly =
    new Wrapper(impl)
}
