package zio.aws.ses.model
import scala.jdk.CollectionConverters._
sealed trait VerificationStatus {
  def unwrap: software.amazon.awssdk.services.ses.model.VerificationStatus
}
object VerificationStatus {
  def wrap(
      value: software.amazon.awssdk.services.ses.model.VerificationStatus
  ): zio.aws.ses.model.VerificationStatus = value match {
    case software.amazon.awssdk.services.ses.model.VerificationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ses.model.VerificationStatus.PENDING =>
      val r = Pending
      r
    case software.amazon.awssdk.services.ses.model.VerificationStatus.SUCCESS =>
      val r = Success
      r
    case software.amazon.awssdk.services.ses.model.VerificationStatus.FAILED =>
      val r = Failed
      r
    case software.amazon.awssdk.services.ses.model.VerificationStatus.TEMPORARY_FAILURE =>
      val r = TemporaryFailure
      r
    case software.amazon.awssdk.services.ses.model.VerificationStatus.NOT_STARTED =>
      val r = NotStarted
      r
  }
  case object unknownToSdkVersion extends zio.aws.ses.model.VerificationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.VerificationStatus =
      software.amazon.awssdk.services.ses.model.VerificationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Pending extends zio.aws.ses.model.VerificationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.VerificationStatus =
      software.amazon.awssdk.services.ses.model.VerificationStatus.PENDING
  }
  case object Success extends zio.aws.ses.model.VerificationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.VerificationStatus =
      software.amazon.awssdk.services.ses.model.VerificationStatus.SUCCESS
  }
  case object Failed extends zio.aws.ses.model.VerificationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.VerificationStatus =
      software.amazon.awssdk.services.ses.model.VerificationStatus.FAILED
  }
  case object TemporaryFailure extends zio.aws.ses.model.VerificationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.VerificationStatus =
      software.amazon.awssdk.services.ses.model.VerificationStatus.TEMPORARY_FAILURE
  }
  case object NotStarted extends zio.aws.ses.model.VerificationStatus {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.VerificationStatus =
      software.amazon.awssdk.services.ses.model.VerificationStatus.NOT_STARTED
  }
}
