package zio.aws.ses.model
import zio.aws.ses.model.primitives.Identity
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetIdentityMailFromDomainAttributesRequest(
    identities: Iterable[Identity]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.GetIdentityMailFromDomainAttributesRequest = {
    import GetIdentityMailFromDomainAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.GetIdentityMailFromDomainAttributesRequest
      .builder()
      .identities(identities.map { item =>
        Identity.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.ses.model.GetIdentityMailFromDomainAttributesRequest.ReadOnly =
    zio.aws.ses.model.GetIdentityMailFromDomainAttributesRequest
      .wrap(buildAwsValue())
}
object GetIdentityMailFromDomainAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.GetIdentityMailFromDomainAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ses.model.GetIdentityMailFromDomainAttributesRequest =
      zio.aws.ses.model.GetIdentityMailFromDomainAttributesRequest(identities)
    def identities: List[Identity]
    def getIdentities: ZIO[Any, Nothing, List[Identity]] =
      ZIO.succeed(identities)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.GetIdentityMailFromDomainAttributesRequest
  ) extends zio.aws.ses.model.GetIdentityMailFromDomainAttributesRequest.ReadOnly {
    override val identities: List[Identity] = impl
      .identities()
      .asScala
      .map { item =>
        zio.aws.ses.model.primitives.Identity(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.GetIdentityMailFromDomainAttributesRequest
  ): zio.aws.ses.model.GetIdentityMailFromDomainAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
