package zio.aws.ses.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetSendStatisticsResponse(
    sendDataPoints: Option[Iterable[zio.aws.ses.model.SendDataPoint]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.GetSendStatisticsResponse = {
    import GetSendStatisticsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.GetSendStatisticsResponse
      .builder()
      .optionallyWith(
        sendDataPoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sendDataPoints)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.GetSendStatisticsResponse.ReadOnly =
    zio.aws.ses.model.GetSendStatisticsResponse.wrap(buildAwsValue())
}
object GetSendStatisticsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.GetSendStatisticsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.GetSendStatisticsResponse =
      zio.aws.ses.model.GetSendStatisticsResponse(
        sendDataPoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def sendDataPoints: Option[List[zio.aws.ses.model.SendDataPoint.ReadOnly]]
    def getSendDataPoints
        : ZIO[Any, AwsError, List[zio.aws.ses.model.SendDataPoint.ReadOnly]] =
      AwsError.unwrapOptionField("sendDataPoints", sendDataPoints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.GetSendStatisticsResponse
  ) extends zio.aws.ses.model.GetSendStatisticsResponse.ReadOnly {
    override val sendDataPoints
        : Option[List[zio.aws.ses.model.SendDataPoint.ReadOnly]] = scala
      .Option(impl.sendDataPoints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ses.model.SendDataPoint.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.GetSendStatisticsResponse
  ): zio.aws.ses.model.GetSendStatisticsResponse.ReadOnly = new Wrapper(impl)
}
