package zio.aws.ses.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetTemplateResponse(
    template: Option[zio.aws.ses.model.Template] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.GetTemplateResponse = {
    import GetTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.GetTemplateResponse
      .builder()
      .optionallyWith(template.map(value => value.buildAwsValue()))(_.template)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.GetTemplateResponse.ReadOnly =
    zio.aws.ses.model.GetTemplateResponse.wrap(buildAwsValue())
}
object GetTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.GetTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.GetTemplateResponse = zio.aws.ses.model
      .GetTemplateResponse(template.map(value => value.asEditable))
    def template: Option[zio.aws.ses.model.Template.ReadOnly]
    def getTemplate: ZIO[Any, AwsError, zio.aws.ses.model.Template.ReadOnly] =
      AwsError.unwrapOptionField("template", template)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.GetTemplateResponse
  ) extends zio.aws.ses.model.GetTemplateResponse.ReadOnly {
    override val template: Option[zio.aws.ses.model.Template.ReadOnly] = scala
      .Option(impl.template())
      .map(value => zio.aws.ses.model.Template.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.GetTemplateResponse
  ): zio.aws.ses.model.GetTemplateResponse.ReadOnly = new Wrapper(impl)
}
