package zio.aws.ses.model
import zio.aws.ses.model.primitives.{VerificationToken, Enabled}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class IdentityDkimAttributes(
    dkimEnabled: Enabled,
    dkimVerificationStatus: zio.aws.ses.model.VerificationStatus,
    dkimTokens: Option[Iterable[VerificationToken]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.IdentityDkimAttributes = {
    import IdentityDkimAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.IdentityDkimAttributes
      .builder()
      .dkimEnabled(Enabled.unwrap(dkimEnabled): java.lang.Boolean)
      .dkimVerificationStatus(dkimVerificationStatus.unwrap)
      .optionallyWith(
        dkimTokens.map(value =>
          value.map { item =>
            VerificationToken.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.dkimTokens)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.IdentityDkimAttributes.ReadOnly =
    zio.aws.ses.model.IdentityDkimAttributes.wrap(buildAwsValue())
}
object IdentityDkimAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.IdentityDkimAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.IdentityDkimAttributes =
      zio.aws.ses.model.IdentityDkimAttributes(
        dkimEnabled,
        dkimVerificationStatus,
        dkimTokens.map(value => value)
      )
    def dkimEnabled: Enabled
    def dkimVerificationStatus: zio.aws.ses.model.VerificationStatus
    def dkimTokens: Option[List[VerificationToken]]
    def getDkimEnabled: ZIO[Any, Nothing, Enabled] = ZIO.succeed(dkimEnabled)
    def getDkimVerificationStatus
        : ZIO[Any, Nothing, zio.aws.ses.model.VerificationStatus] =
      ZIO.succeed(dkimVerificationStatus)
    def getDkimTokens: ZIO[Any, AwsError, List[VerificationToken]] =
      AwsError.unwrapOptionField("dkimTokens", dkimTokens)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.IdentityDkimAttributes
  ) extends zio.aws.ses.model.IdentityDkimAttributes.ReadOnly {
    override val dkimEnabled: Enabled =
      zio.aws.ses.model.primitives.Enabled(impl.dkimEnabled())
    override val dkimVerificationStatus: zio.aws.ses.model.VerificationStatus =
      zio.aws.ses.model.VerificationStatus.wrap(impl.dkimVerificationStatus())
    override val dkimTokens: Option[List[VerificationToken]] = scala
      .Option(impl.dkimTokens())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ses.model.primitives.VerificationToken(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.IdentityDkimAttributes
  ): zio.aws.ses.model.IdentityDkimAttributes.ReadOnly = new Wrapper(impl)
}
