package zio.aws.ses.model
import java.lang.Integer
import zio.aws.ses.model.primitives.{MaxItems, NextToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListConfigurationSetsRequest(
    nextToken: Option[NextToken] = None,
    maxItems: Option[MaxItems] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.ListConfigurationSetsRequest = {
    import ListConfigurationSetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.ListConfigurationSetsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(maxItems.map(value => MaxItems.unwrap(value): Integer))(
        _.maxItems
      )
      .build()
  }
  def asReadOnly: zio.aws.ses.model.ListConfigurationSetsRequest.ReadOnly =
    zio.aws.ses.model.ListConfigurationSetsRequest.wrap(buildAwsValue())
}
object ListConfigurationSetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.ListConfigurationSetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.ListConfigurationSetsRequest =
      zio.aws.ses.model.ListConfigurationSetsRequest(
        nextToken.map(value => value),
        maxItems.map(value => value)
      )
    def nextToken: Option[NextToken]
    def maxItems: Option[MaxItems]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxItems: ZIO[Any, AwsError, MaxItems] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.ListConfigurationSetsRequest
  ) extends zio.aws.ses.model.ListConfigurationSetsRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ses.model.primitives.NextToken(value))
    override val maxItems: Option[MaxItems] = scala
      .Option(impl.maxItems())
      .map(value => zio.aws.ses.model.primitives.MaxItems(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.ListConfigurationSetsRequest
  ): zio.aws.ses.model.ListConfigurationSetsRequest.ReadOnly = new Wrapper(impl)
}
