package zio.aws.ses.model
import zio.aws.ses.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListConfigurationSetsResponse(
    configurationSets: Option[Iterable[zio.aws.ses.model.ConfigurationSet]] =
      None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.ListConfigurationSetsResponse = {
    import ListConfigurationSetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.ListConfigurationSetsResponse
      .builder()
      .optionallyWith(
        configurationSets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.configurationSets)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.ListConfigurationSetsResponse.ReadOnly =
    zio.aws.ses.model.ListConfigurationSetsResponse.wrap(buildAwsValue())
}
object ListConfigurationSetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.ListConfigurationSetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.ListConfigurationSetsResponse =
      zio.aws.ses.model.ListConfigurationSetsResponse(
        configurationSets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def configurationSets
        : Option[List[zio.aws.ses.model.ConfigurationSet.ReadOnly]]
    def nextToken: Option[NextToken]
    def getConfigurationSets: ZIO[Any, AwsError, List[
      zio.aws.ses.model.ConfigurationSet.ReadOnly
    ]] = AwsError.unwrapOptionField("configurationSets", configurationSets)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.ListConfigurationSetsResponse
  ) extends zio.aws.ses.model.ListConfigurationSetsResponse.ReadOnly {
    override val configurationSets
        : Option[List[zio.aws.ses.model.ConfigurationSet.ReadOnly]] = scala
      .Option(impl.configurationSets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ses.model.ConfigurationSet.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ses.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.ListConfigurationSetsResponse
  ): zio.aws.ses.model.ListConfigurationSetsResponse.ReadOnly = new Wrapper(
    impl
  )
}
