package zio.aws.ses.model
import zio.aws.ses.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListCustomVerificationEmailTemplatesResponse(
    customVerificationEmailTemplates: Option[
      Iterable[zio.aws.ses.model.CustomVerificationEmailTemplate]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesResponse = {
    import ListCustomVerificationEmailTemplatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesResponse
      .builder()
      .optionallyWith(
        customVerificationEmailTemplates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customVerificationEmailTemplates)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ses.model.ListCustomVerificationEmailTemplatesResponse.ReadOnly =
    zio.aws.ses.model.ListCustomVerificationEmailTemplatesResponse
      .wrap(buildAwsValue())
}
object ListCustomVerificationEmailTemplatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ses.model.ListCustomVerificationEmailTemplatesResponse =
      zio.aws.ses.model.ListCustomVerificationEmailTemplatesResponse(
        customVerificationEmailTemplates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def customVerificationEmailTemplates: Option[
      List[zio.aws.ses.model.CustomVerificationEmailTemplate.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getCustomVerificationEmailTemplates: ZIO[Any, AwsError, List[
      zio.aws.ses.model.CustomVerificationEmailTemplate.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "customVerificationEmailTemplates",
      customVerificationEmailTemplates
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesResponse
  ) extends zio.aws.ses.model.ListCustomVerificationEmailTemplatesResponse.ReadOnly {
    override val customVerificationEmailTemplates: Option[
      List[zio.aws.ses.model.CustomVerificationEmailTemplate.ReadOnly]
    ] = scala
      .Option(impl.customVerificationEmailTemplates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ses.model.CustomVerificationEmailTemplate.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ses.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.ListCustomVerificationEmailTemplatesResponse
  ): zio.aws.ses.model.ListCustomVerificationEmailTemplatesResponse.ReadOnly =
    new Wrapper(impl)
}
