package zio.aws.ses.model
import zio.aws.ses.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListReceiptRuleSetsResponse(
    ruleSets: Option[Iterable[zio.aws.ses.model.ReceiptRuleSetMetadata]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.ListReceiptRuleSetsResponse = {
    import ListReceiptRuleSetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.ListReceiptRuleSetsResponse
      .builder()
      .optionallyWith(
        ruleSets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.ruleSets)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.ListReceiptRuleSetsResponse.ReadOnly =
    zio.aws.ses.model.ListReceiptRuleSetsResponse.wrap(buildAwsValue())
}
object ListReceiptRuleSetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.ListReceiptRuleSetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.ListReceiptRuleSetsResponse =
      zio.aws.ses.model.ListReceiptRuleSetsResponse(
        ruleSets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def ruleSets
        : Option[List[zio.aws.ses.model.ReceiptRuleSetMetadata.ReadOnly]]
    def nextToken: Option[NextToken]
    def getRuleSets: ZIO[Any, AwsError, List[
      zio.aws.ses.model.ReceiptRuleSetMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("ruleSets", ruleSets)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.ListReceiptRuleSetsResponse
  ) extends zio.aws.ses.model.ListReceiptRuleSetsResponse.ReadOnly {
    override val ruleSets
        : Option[List[zio.aws.ses.model.ReceiptRuleSetMetadata.ReadOnly]] =
      scala
        .Option(impl.ruleSets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ses.model.ReceiptRuleSetMetadata.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ses.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.ListReceiptRuleSetsResponse
  ): zio.aws.ses.model.ListReceiptRuleSetsResponse.ReadOnly = new Wrapper(impl)
}
