package zio.aws.ses.model
import zio.aws.ses.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListTemplatesResponse(
    templatesMetadata: Option[Iterable[zio.aws.ses.model.TemplateMetadata]] =
      None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.ListTemplatesResponse = {
    import ListTemplatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.ListTemplatesResponse
      .builder()
      .optionallyWith(
        templatesMetadata.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.templatesMetadata)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.ListTemplatesResponse.ReadOnly =
    zio.aws.ses.model.ListTemplatesResponse.wrap(buildAwsValue())
}
object ListTemplatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.ListTemplatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.ListTemplatesResponse =
      zio.aws.ses.model.ListTemplatesResponse(
        templatesMetadata.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def templatesMetadata
        : Option[List[zio.aws.ses.model.TemplateMetadata.ReadOnly]]
    def nextToken: Option[NextToken]
    def getTemplatesMetadata: ZIO[Any, AwsError, List[
      zio.aws.ses.model.TemplateMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("templatesMetadata", templatesMetadata)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.ListTemplatesResponse
  ) extends zio.aws.ses.model.ListTemplatesResponse.ReadOnly {
    override val templatesMetadata
        : Option[List[zio.aws.ses.model.TemplateMetadata.ReadOnly]] = scala
      .Option(impl.templatesMetadata())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ses.model.TemplateMetadata.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ses.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.ListTemplatesResponse
  ): zio.aws.ses.model.ListTemplatesResponse.ReadOnly = new Wrapper(impl)
}
