package zio.aws.ses.model
import zio.aws.ses.model.primitives.{Timestamp, ReceiptRuleSetName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ReceiptRuleSetMetadata(
    name: Option[ReceiptRuleSetName] = None,
    createdTimestamp: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.ReceiptRuleSetMetadata = {
    import ReceiptRuleSetMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.ReceiptRuleSetMetadata
      .builder()
      .optionallyWith(
        name.map(value => ReceiptRuleSetName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        createdTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.ReceiptRuleSetMetadata.ReadOnly =
    zio.aws.ses.model.ReceiptRuleSetMetadata.wrap(buildAwsValue())
}
object ReceiptRuleSetMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.ReceiptRuleSetMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.ReceiptRuleSetMetadata =
      zio.aws.ses.model.ReceiptRuleSetMetadata(
        name.map(value => value),
        createdTimestamp.map(value => value)
      )
    def name: Option[ReceiptRuleSetName]
    def createdTimestamp: Option[Timestamp]
    def getName: ZIO[Any, AwsError, ReceiptRuleSetName] =
      AwsError.unwrapOptionField("name", name)
    def getCreatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.ReceiptRuleSetMetadata
  ) extends zio.aws.ses.model.ReceiptRuleSetMetadata.ReadOnly {
    override val name: Option[ReceiptRuleSetName] = scala
      .Option(impl.name())
      .map(value => zio.aws.ses.model.primitives.ReceiptRuleSetName(value))
    override val createdTimestamp: Option[Timestamp] = scala
      .Option(impl.createdTimestamp())
      .map(value => zio.aws.ses.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.ReceiptRuleSetMetadata
  ): zio.aws.ses.model.ReceiptRuleSetMetadata.ReadOnly = new Wrapper(impl)
}
