package zio.aws.ses.model
import zio.aws.ses.model.primitives.{ReceiptRuleName, ReceiptRuleSetName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ReorderReceiptRuleSetRequest(
    ruleSetName: ReceiptRuleSetName,
    ruleNames: Iterable[ReceiptRuleName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.ReorderReceiptRuleSetRequest = {
    import ReorderReceiptRuleSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.ReorderReceiptRuleSetRequest
      .builder()
      .ruleSetName(ReceiptRuleSetName.unwrap(ruleSetName): java.lang.String)
      .ruleNames(ruleNames.map { item =>
        ReceiptRuleName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.ReorderReceiptRuleSetRequest.ReadOnly =
    zio.aws.ses.model.ReorderReceiptRuleSetRequest.wrap(buildAwsValue())
}
object ReorderReceiptRuleSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.ReorderReceiptRuleSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.ReorderReceiptRuleSetRequest =
      zio.aws.ses.model.ReorderReceiptRuleSetRequest(ruleSetName, ruleNames)
    def ruleSetName: ReceiptRuleSetName
    def ruleNames: List[ReceiptRuleName]
    def getRuleSetName: ZIO[Any, Nothing, ReceiptRuleSetName] =
      ZIO.succeed(ruleSetName)
    def getRuleNames: ZIO[Any, Nothing, List[ReceiptRuleName]] =
      ZIO.succeed(ruleNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.ReorderReceiptRuleSetRequest
  ) extends zio.aws.ses.model.ReorderReceiptRuleSetRequest.ReadOnly {
    override val ruleSetName: ReceiptRuleSetName =
      zio.aws.ses.model.primitives.ReceiptRuleSetName(impl.ruleSetName())
    override val ruleNames: List[ReceiptRuleName] = impl
      .ruleNames()
      .asScala
      .map { item =>
        zio.aws.ses.model.primitives.ReceiptRuleName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.ReorderReceiptRuleSetRequest
  ): zio.aws.ses.model.ReorderReceiptRuleSetRequest.ReadOnly = new Wrapper(impl)
}
