package zio.aws.ses.model
import zio.aws.ses.model.primitives.{
  S3KeyPrefix,
  S3BucketName,
  AmazonResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class S3Action(
    topicArn: Option[AmazonResourceName] = None,
    bucketName: S3BucketName,
    objectKeyPrefix: Option[S3KeyPrefix] = None,
    kmsKeyArn: Option[AmazonResourceName] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ses.model.S3Action = {
    import S3Action.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.S3Action
      .builder()
      .optionallyWith(
        topicArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.topicArn)
      .bucketName(S3BucketName.unwrap(bucketName): java.lang.String)
      .optionallyWith(
        objectKeyPrefix.map(value =>
          S3KeyPrefix.unwrap(value): java.lang.String
        )
      )(_.objectKeyPrefix)
      .optionallyWith(
        kmsKeyArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.kmsKeyArn)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.S3Action.ReadOnly =
    zio.aws.ses.model.S3Action.wrap(buildAwsValue())
}
object S3Action {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ses.model.S3Action] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.S3Action = zio.aws.ses.model.S3Action(
      topicArn.map(value => value),
      bucketName,
      objectKeyPrefix.map(value => value),
      kmsKeyArn.map(value => value)
    )
    def topicArn: Option[AmazonResourceName]
    def bucketName: S3BucketName
    def objectKeyPrefix: Option[S3KeyPrefix]
    def kmsKeyArn: Option[AmazonResourceName]
    def getTopicArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("topicArn", topicArn)
    def getBucketName: ZIO[Any, Nothing, S3BucketName] = ZIO.succeed(bucketName)
    def getObjectKeyPrefix: ZIO[Any, AwsError, S3KeyPrefix] =
      AwsError.unwrapOptionField("objectKeyPrefix", objectKeyPrefix)
    def getKmsKeyArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("kmsKeyArn", kmsKeyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.S3Action
  ) extends zio.aws.ses.model.S3Action.ReadOnly {
    override val topicArn: Option[AmazonResourceName] = scala
      .Option(impl.topicArn())
      .map(value => zio.aws.ses.model.primitives.AmazonResourceName(value))
    override val bucketName: S3BucketName =
      zio.aws.ses.model.primitives.S3BucketName(impl.bucketName())
    override val objectKeyPrefix: Option[S3KeyPrefix] = scala
      .Option(impl.objectKeyPrefix())
      .map(value => zio.aws.ses.model.primitives.S3KeyPrefix(value))
    override val kmsKeyArn: Option[AmazonResourceName] = scala
      .Option(impl.kmsKeyArn())
      .map(value => zio.aws.ses.model.primitives.AmazonResourceName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.S3Action
  ): zio.aws.ses.model.S3Action.ReadOnly = new Wrapper(impl)
}
