package zio.aws.ses.model
import zio.aws.ses.model.primitives.{Counter, Timestamp}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class SendDataPoint(
    timestamp: Option[Timestamp] = None,
    deliveryAttempts: Option[Counter] = None,
    bounces: Option[Counter] = None,
    complaints: Option[Counter] = None,
    rejects: Option[Counter] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.SendDataPoint = {
    import SendDataPoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.SendDataPoint
      .builder()
      .optionallyWith(timestamp.map(value => Timestamp.unwrap(value): Instant))(
        _.timestamp
      )
      .optionallyWith(
        deliveryAttempts.map(value => Counter.unwrap(value): java.lang.Long)
      )(_.deliveryAttempts)
      .optionallyWith(
        bounces.map(value => Counter.unwrap(value): java.lang.Long)
      )(_.bounces)
      .optionallyWith(
        complaints.map(value => Counter.unwrap(value): java.lang.Long)
      )(_.complaints)
      .optionallyWith(
        rejects.map(value => Counter.unwrap(value): java.lang.Long)
      )(_.rejects)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.SendDataPoint.ReadOnly =
    zio.aws.ses.model.SendDataPoint.wrap(buildAwsValue())
}
object SendDataPoint {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ses.model.SendDataPoint] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.SendDataPoint =
      zio.aws.ses.model.SendDataPoint(
        timestamp.map(value => value),
        deliveryAttempts.map(value => value),
        bounces.map(value => value),
        complaints.map(value => value),
        rejects.map(value => value)
      )
    def timestamp: Option[Timestamp]
    def deliveryAttempts: Option[Counter]
    def bounces: Option[Counter]
    def complaints: Option[Counter]
    def rejects: Option[Counter]
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
    def getDeliveryAttempts: ZIO[Any, AwsError, Counter] =
      AwsError.unwrapOptionField("deliveryAttempts", deliveryAttempts)
    def getBounces: ZIO[Any, AwsError, Counter] =
      AwsError.unwrapOptionField("bounces", bounces)
    def getComplaints: ZIO[Any, AwsError, Counter] =
      AwsError.unwrapOptionField("complaints", complaints)
    def getRejects: ZIO[Any, AwsError, Counter] =
      AwsError.unwrapOptionField("rejects", rejects)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.SendDataPoint
  ) extends zio.aws.ses.model.SendDataPoint.ReadOnly {
    override val timestamp: Option[Timestamp] = scala
      .Option(impl.timestamp())
      .map(value => zio.aws.ses.model.primitives.Timestamp(value))
    override val deliveryAttempts: Option[Counter] = scala
      .Option(impl.deliveryAttempts())
      .map(value => zio.aws.ses.model.primitives.Counter(value))
    override val bounces: Option[Counter] = scala
      .Option(impl.bounces())
      .map(value => zio.aws.ses.model.primitives.Counter(value))
    override val complaints: Option[Counter] = scala
      .Option(impl.complaints())
      .map(value => zio.aws.ses.model.primitives.Counter(value))
    override val rejects: Option[Counter] = scala
      .Option(impl.rejects())
      .map(value => zio.aws.ses.model.primitives.Counter(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.SendDataPoint
  ): zio.aws.ses.model.SendDataPoint.ReadOnly = new Wrapper(impl)
}
