package zio.aws.ses.model
import zio.aws.ses.model.primitives.{
  ConfigurationSetName,
  AmazonResourceName,
  Address
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SendEmailRequest(
    source: Address,
    destination: zio.aws.ses.model.Destination,
    message: zio.aws.ses.model.Message,
    replyToAddresses: Option[Iterable[Address]] = None,
    returnPath: Option[Address] = None,
    sourceArn: Option[AmazonResourceName] = None,
    returnPathArn: Option[AmazonResourceName] = None,
    tags: Option[Iterable[zio.aws.ses.model.MessageTag]] = None,
    configurationSetName: Option[ConfigurationSetName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.SendEmailRequest = {
    import SendEmailRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.SendEmailRequest
      .builder()
      .source(Address.unwrap(source): java.lang.String)
      .destination(destination.buildAwsValue())
      .message(message.buildAwsValue())
      .optionallyWith(
        replyToAddresses.map(value =>
          value.map { item =>
            Address.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.replyToAddresses)
      .optionallyWith(
        returnPath.map(value => Address.unwrap(value): java.lang.String)
      )(_.returnPath)
      .optionallyWith(
        sourceArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.sourceArn)
      .optionallyWith(
        returnPathArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.returnPathArn)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        configurationSetName.map(value =>
          ConfigurationSetName.unwrap(value): java.lang.String
        )
      )(_.configurationSetName)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.SendEmailRequest.ReadOnly =
    zio.aws.ses.model.SendEmailRequest.wrap(buildAwsValue())
}
object SendEmailRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.SendEmailRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.SendEmailRequest =
      zio.aws.ses.model.SendEmailRequest(
        source,
        destination.asEditable,
        message.asEditable,
        replyToAddresses.map(value => value),
        returnPath.map(value => value),
        sourceArn.map(value => value),
        returnPathArn.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        configurationSetName.map(value => value)
      )
    def source: Address
    def destination: zio.aws.ses.model.Destination.ReadOnly
    def message: zio.aws.ses.model.Message.ReadOnly
    def replyToAddresses: Option[List[Address]]
    def returnPath: Option[Address]
    def sourceArn: Option[AmazonResourceName]
    def returnPathArn: Option[AmazonResourceName]
    def tags: Option[List[zio.aws.ses.model.MessageTag.ReadOnly]]
    def configurationSetName: Option[ConfigurationSetName]
    def getSource: ZIO[Any, Nothing, Address] = ZIO.succeed(source)
    def getDestination
        : ZIO[Any, Nothing, zio.aws.ses.model.Destination.ReadOnly] =
      ZIO.succeed(destination)
    def getMessage: ZIO[Any, Nothing, zio.aws.ses.model.Message.ReadOnly] =
      ZIO.succeed(message)
    def getReplyToAddresses: ZIO[Any, AwsError, List[Address]] =
      AwsError.unwrapOptionField("replyToAddresses", replyToAddresses)
    def getReturnPath: ZIO[Any, AwsError, Address] =
      AwsError.unwrapOptionField("returnPath", returnPath)
    def getSourceArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("sourceArn", sourceArn)
    def getReturnPathArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("returnPathArn", returnPathArn)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.ses.model.MessageTag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getConfigurationSetName: ZIO[Any, AwsError, ConfigurationSetName] =
      AwsError.unwrapOptionField("configurationSetName", configurationSetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.SendEmailRequest
  ) extends zio.aws.ses.model.SendEmailRequest.ReadOnly {
    override val source: Address =
      zio.aws.ses.model.primitives.Address(impl.source())
    override val destination: zio.aws.ses.model.Destination.ReadOnly =
      zio.aws.ses.model.Destination.wrap(impl.destination())
    override val message: zio.aws.ses.model.Message.ReadOnly =
      zio.aws.ses.model.Message.wrap(impl.message())
    override val replyToAddresses: Option[List[Address]] = scala
      .Option(impl.replyToAddresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ses.model.primitives.Address(item)
        }.toList
      )
    override val returnPath: Option[Address] = scala
      .Option(impl.returnPath())
      .map(value => zio.aws.ses.model.primitives.Address(value))
    override val sourceArn: Option[AmazonResourceName] = scala
      .Option(impl.sourceArn())
      .map(value => zio.aws.ses.model.primitives.AmazonResourceName(value))
    override val returnPathArn: Option[AmazonResourceName] = scala
      .Option(impl.returnPathArn())
      .map(value => zio.aws.ses.model.primitives.AmazonResourceName(value))
    override val tags: Option[List[zio.aws.ses.model.MessageTag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ses.model.MessageTag.wrap(item)
          }.toList
        )
    override val configurationSetName: Option[ConfigurationSetName] = scala
      .Option(impl.configurationSetName())
      .map(value => zio.aws.ses.model.primitives.ConfigurationSetName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.SendEmailRequest
  ): zio.aws.ses.model.SendEmailRequest.ReadOnly = new Wrapper(impl)
}
