package zio.aws.ses.model
import zio.aws.ses.model.primitives.ReceiptRuleSetName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SetActiveReceiptRuleSetRequest(
    ruleSetName: Option[ReceiptRuleSetName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.SetActiveReceiptRuleSetRequest = {
    import SetActiveReceiptRuleSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.SetActiveReceiptRuleSetRequest
      .builder()
      .optionallyWith(
        ruleSetName.map(value =>
          ReceiptRuleSetName.unwrap(value): java.lang.String
        )
      )(_.ruleSetName)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.SetActiveReceiptRuleSetRequest.ReadOnly =
    zio.aws.ses.model.SetActiveReceiptRuleSetRequest.wrap(buildAwsValue())
}
object SetActiveReceiptRuleSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.SetActiveReceiptRuleSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.SetActiveReceiptRuleSetRequest =
      zio.aws.ses.model
        .SetActiveReceiptRuleSetRequest(ruleSetName.map(value => value))
    def ruleSetName: Option[ReceiptRuleSetName]
    def getRuleSetName: ZIO[Any, AwsError, ReceiptRuleSetName] =
      AwsError.unwrapOptionField("ruleSetName", ruleSetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.SetActiveReceiptRuleSetRequest
  ) extends zio.aws.ses.model.SetActiveReceiptRuleSetRequest.ReadOnly {
    override val ruleSetName: Option[ReceiptRuleSetName] = scala
      .Option(impl.ruleSetName())
      .map(value => zio.aws.ses.model.primitives.ReceiptRuleSetName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.SetActiveReceiptRuleSetRequest
  ): zio.aws.ses.model.SetActiveReceiptRuleSetRequest.ReadOnly = new Wrapper(
    impl
  )
}
