package zio.aws.ses.model
import zio.aws.ses.model.primitives.ConfigurationSetName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteConfigurationSetRequest(
    configurationSetName: ConfigurationSetName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.DeleteConfigurationSetRequest = {
    import DeleteConfigurationSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.DeleteConfigurationSetRequest
      .builder()
      .configurationSetName(
        ConfigurationSetName.unwrap(configurationSetName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.ses.model.DeleteConfigurationSetRequest.ReadOnly =
    zio.aws.ses.model.DeleteConfigurationSetRequest.wrap(buildAwsValue())
}
object DeleteConfigurationSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.DeleteConfigurationSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.DeleteConfigurationSetRequest =
      zio.aws.ses.model.DeleteConfigurationSetRequest(configurationSetName)
    def configurationSetName: ConfigurationSetName
    def getConfigurationSetName: ZIO[Any, Nothing, ConfigurationSetName] =
      ZIO.succeed(configurationSetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.DeleteConfigurationSetRequest
  ) extends zio.aws.ses.model.DeleteConfigurationSetRequest.ReadOnly {
    override val configurationSetName: ConfigurationSetName =
      zio.aws.ses.model.primitives
        .ConfigurationSetName(impl.configurationSetName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.DeleteConfigurationSetRequest
  ): zio.aws.ses.model.DeleteConfigurationSetRequest.ReadOnly = new Wrapper(
    impl
  )
}
