package zio.aws.ses.model
import zio.aws.ses.model.primitives.TemplateName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetCustomVerificationEmailTemplateRequest(
    templateName: TemplateName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.GetCustomVerificationEmailTemplateRequest = {
    import GetCustomVerificationEmailTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.GetCustomVerificationEmailTemplateRequest
      .builder()
      .templateName(TemplateName.unwrap(templateName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ses.model.GetCustomVerificationEmailTemplateRequest.ReadOnly =
    zio.aws.ses.model.GetCustomVerificationEmailTemplateRequest
      .wrap(buildAwsValue())
}
object GetCustomVerificationEmailTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.GetCustomVerificationEmailTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ses.model.GetCustomVerificationEmailTemplateRequest =
      zio.aws.ses.model.GetCustomVerificationEmailTemplateRequest(templateName)
    def templateName: TemplateName
    def getTemplateName: ZIO[Any, Nothing, TemplateName] =
      ZIO.succeed(templateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.GetCustomVerificationEmailTemplateRequest
  ) extends zio.aws.ses.model.GetCustomVerificationEmailTemplateRequest.ReadOnly {
    override val templateName: TemplateName =
      zio.aws.ses.model.primitives.TemplateName(impl.templateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.GetCustomVerificationEmailTemplateRequest
  ): zio.aws.ses.model.GetCustomVerificationEmailTemplateRequest.ReadOnly =
    new Wrapper(impl)
}
