package zio.aws.ses.model
import zio.aws.ses.model.primitives.VerificationToken
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class VerifyDomainDkimResponse(
    dkimTokens: Iterable[VerificationToken]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.VerifyDomainDkimResponse = {
    import VerifyDomainDkimResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.VerifyDomainDkimResponse
      .builder()
      .dkimTokens(dkimTokens.map { item =>
        VerificationToken.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.VerifyDomainDkimResponse.ReadOnly =
    zio.aws.ses.model.VerifyDomainDkimResponse.wrap(buildAwsValue())
}
object VerifyDomainDkimResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.VerifyDomainDkimResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.VerifyDomainDkimResponse =
      zio.aws.ses.model.VerifyDomainDkimResponse(dkimTokens)
    def dkimTokens: List[VerificationToken]
    def getDkimTokens: ZIO[Any, Nothing, List[VerificationToken]] =
      ZIO.succeed(dkimTokens)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.VerifyDomainDkimResponse
  ) extends zio.aws.ses.model.VerifyDomainDkimResponse.ReadOnly {
    override val dkimTokens: List[VerificationToken] = impl
      .dkimTokens()
      .asScala
      .map { item =>
        zio.aws.ses.model.primitives.VerificationToken(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.VerifyDomainDkimResponse
  ): zio.aws.ses.model.VerifyDomainDkimResponse.ReadOnly = new Wrapper(impl)
}
