package zio.aws.ses.model
import scala.jdk.CollectionConverters._
sealed trait BehaviorOnMXFailure {
  def unwrap: software.amazon.awssdk.services.ses.model.BehaviorOnMXFailure
}
object BehaviorOnMXFailure {
  def wrap(
      value: software.amazon.awssdk.services.ses.model.BehaviorOnMXFailure
  ): zio.aws.ses.model.BehaviorOnMXFailure = value match {
    case software.amazon.awssdk.services.ses.model.BehaviorOnMXFailure.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ses.model.BehaviorOnMXFailure.USE_DEFAULT_VALUE =>
      val r = UseDefaultValue
      r
    case software.amazon.awssdk.services.ses.model.BehaviorOnMXFailure.REJECT_MESSAGE =>
      val r = RejectMessage
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ses.model.BehaviorOnMXFailure {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.BehaviorOnMXFailure =
      software.amazon.awssdk.services.ses.model.BehaviorOnMXFailure.UNKNOWN_TO_SDK_VERSION
  }
  case object UseDefaultValue extends zio.aws.ses.model.BehaviorOnMXFailure {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.BehaviorOnMXFailure =
      software.amazon.awssdk.services.ses.model.BehaviorOnMXFailure.USE_DEFAULT_VALUE
  }
  case object RejectMessage extends zio.aws.ses.model.BehaviorOnMXFailure {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.BehaviorOnMXFailure =
      software.amazon.awssdk.services.ses.model.BehaviorOnMXFailure.REJECT_MESSAGE
  }
}
