package zio.aws.ses.model
import zio.aws.ses.model.primitives.{Enabled, Identity}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SetIdentityDkimEnabledRequest(
    identity: Identity,
    dkimEnabled: Enabled
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.SetIdentityDkimEnabledRequest = {
    import SetIdentityDkimEnabledRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.SetIdentityDkimEnabledRequest
      .builder()
      .identity(Identity.unwrap(identity): java.lang.String)
      .dkimEnabled(Enabled.unwrap(dkimEnabled): java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.SetIdentityDkimEnabledRequest.ReadOnly =
    zio.aws.ses.model.SetIdentityDkimEnabledRequest.wrap(buildAwsValue())
}
object SetIdentityDkimEnabledRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.SetIdentityDkimEnabledRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.SetIdentityDkimEnabledRequest =
      zio.aws.ses.model.SetIdentityDkimEnabledRequest(identity, dkimEnabled)
    def identity: Identity
    def dkimEnabled: Enabled
    def getIdentity: ZIO[Any, Nothing, Identity] = ZIO.succeed(identity)
    def getDkimEnabled: ZIO[Any, Nothing, Enabled] = ZIO.succeed(dkimEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.SetIdentityDkimEnabledRequest
  ) extends zio.aws.ses.model.SetIdentityDkimEnabledRequest.ReadOnly {
    override val identity: Identity =
      zio.aws.ses.model.primitives.Identity(impl.identity())
    override val dkimEnabled: Enabled =
      zio.aws.ses.model.primitives.Enabled(impl.dkimEnabled())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.SetIdentityDkimEnabledRequest
  ): zio.aws.ses.model.SetIdentityDkimEnabledRequest.ReadOnly = new Wrapper(
    impl
  )
}
