package zio.aws.ses.model
import zio.aws.ses.model.primitives.ConfigurationSetName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateConfigurationSetEventDestinationRequest(
    configurationSetName: ConfigurationSetName,
    eventDestination: zio.aws.ses.model.EventDestination
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.CreateConfigurationSetEventDestinationRequest = {
    import CreateConfigurationSetEventDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.CreateConfigurationSetEventDestinationRequest
      .builder()
      .configurationSetName(
        ConfigurationSetName.unwrap(configurationSetName): java.lang.String
      )
      .eventDestination(eventDestination.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.ses.model.CreateConfigurationSetEventDestinationRequest.ReadOnly =
    zio.aws.ses.model.CreateConfigurationSetEventDestinationRequest
      .wrap(buildAwsValue())
}
object CreateConfigurationSetEventDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.CreateConfigurationSetEventDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ses.model.CreateConfigurationSetEventDestinationRequest =
      zio.aws.ses.model.CreateConfigurationSetEventDestinationRequest(
        configurationSetName,
        eventDestination.asEditable
      )
    def configurationSetName: ConfigurationSetName
    def eventDestination: zio.aws.ses.model.EventDestination.ReadOnly
    def getConfigurationSetName: ZIO[Any, Nothing, ConfigurationSetName] =
      ZIO.succeed(configurationSetName)
    def getEventDestination
        : ZIO[Any, Nothing, zio.aws.ses.model.EventDestination.ReadOnly] =
      ZIO.succeed(eventDestination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.CreateConfigurationSetEventDestinationRequest
  ) extends zio.aws.ses.model.CreateConfigurationSetEventDestinationRequest.ReadOnly {
    override val configurationSetName: ConfigurationSetName =
      zio.aws.ses.model.primitives
        .ConfigurationSetName(impl.configurationSetName())
    override val eventDestination: zio.aws.ses.model.EventDestination.ReadOnly =
      zio.aws.ses.model.EventDestination.wrap(impl.eventDestination())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.CreateConfigurationSetEventDestinationRequest
  ): zio.aws.ses.model.CreateConfigurationSetEventDestinationRequest.ReadOnly =
    new Wrapper(impl)
}
