package zio.aws.ses.model
import zio.aws.ses.model.primitives.ReceiptRuleSetName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateReceiptRuleSetRequest(ruleSetName: ReceiptRuleSetName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.CreateReceiptRuleSetRequest = {
    import CreateReceiptRuleSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.CreateReceiptRuleSetRequest
      .builder()
      .ruleSetName(ReceiptRuleSetName.unwrap(ruleSetName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.CreateReceiptRuleSetRequest.ReadOnly =
    zio.aws.ses.model.CreateReceiptRuleSetRequest.wrap(buildAwsValue())
}
object CreateReceiptRuleSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.CreateReceiptRuleSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.CreateReceiptRuleSetRequest =
      zio.aws.ses.model.CreateReceiptRuleSetRequest(ruleSetName)
    def ruleSetName: ReceiptRuleSetName
    def getRuleSetName: ZIO[Any, Nothing, ReceiptRuleSetName] =
      ZIO.succeed(ruleSetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.CreateReceiptRuleSetRequest
  ) extends zio.aws.ses.model.CreateReceiptRuleSetRequest.ReadOnly {
    override val ruleSetName: ReceiptRuleSetName =
      zio.aws.ses.model.primitives.ReceiptRuleSetName(impl.ruleSetName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.CreateReceiptRuleSetRequest
  ): zio.aws.ses.model.CreateReceiptRuleSetRequest.ReadOnly = new Wrapper(impl)
}
