package zio.aws.ses.model
import zio.aws.ses.model.primitives.Identity
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetIdentityVerificationAttributesRequest(
    identities: Iterable[Identity]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.GetIdentityVerificationAttributesRequest = {
    import GetIdentityVerificationAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.GetIdentityVerificationAttributesRequest
      .builder()
      .identities(identities.map { item =>
        Identity.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.ses.model.GetIdentityVerificationAttributesRequest.ReadOnly =
    zio.aws.ses.model.GetIdentityVerificationAttributesRequest
      .wrap(buildAwsValue())
}
object GetIdentityVerificationAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.GetIdentityVerificationAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.GetIdentityVerificationAttributesRequest =
      zio.aws.ses.model.GetIdentityVerificationAttributesRequest(identities)
    def identities: List[Identity]
    def getIdentities: ZIO[Any, Nothing, List[Identity]] =
      ZIO.succeed(identities)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.GetIdentityVerificationAttributesRequest
  ) extends zio.aws.ses.model.GetIdentityVerificationAttributesRequest.ReadOnly {
    override val identities: List[Identity] = impl
      .identities()
      .asScala
      .map { item =>
        zio.aws.ses.model.primitives.Identity(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.GetIdentityVerificationAttributesRequest
  ): zio.aws.ses.model.GetIdentityVerificationAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
