package zio.aws.ses.model
import zio.aws.ses.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListReceiptRuleSetsRequest(
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.ListReceiptRuleSetsRequest = {
    import ListReceiptRuleSetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.ListReceiptRuleSetsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.ListReceiptRuleSetsRequest.ReadOnly =
    zio.aws.ses.model.ListReceiptRuleSetsRequest.wrap(buildAwsValue())
}
object ListReceiptRuleSetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.ListReceiptRuleSetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.ListReceiptRuleSetsRequest =
      zio.aws.ses.model
        .ListReceiptRuleSetsRequest(nextToken.map(value => value))
    def nextToken: Optional[NextToken]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.ListReceiptRuleSetsRequest
  ) extends zio.aws.ses.model.ListReceiptRuleSetsRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ses.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.ListReceiptRuleSetsRequest
  ): zio.aws.ses.model.ListReceiptRuleSetsRequest.ReadOnly = new Wrapper(impl)
}
