package zio.aws.ses.model
import zio.aws.ses.model.primitives.Cidr
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ReceiptIpFilter(
    policy: zio.aws.ses.model.ReceiptFilterPolicy,
    cidr: Cidr
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.ReceiptIpFilter = {
    import ReceiptIpFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.ReceiptIpFilter
      .builder()
      .policy(policy.unwrap)
      .cidr(Cidr.unwrap(cidr): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.ReceiptIpFilter.ReadOnly =
    zio.aws.ses.model.ReceiptIpFilter.wrap(buildAwsValue())
}
object ReceiptIpFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.ReceiptIpFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.ReceiptIpFilter =
      zio.aws.ses.model.ReceiptIpFilter(policy, cidr)
    def policy: zio.aws.ses.model.ReceiptFilterPolicy
    def cidr: Cidr
    def getPolicy: ZIO[Any, Nothing, zio.aws.ses.model.ReceiptFilterPolicy] =
      ZIO.succeed(policy)
    def getCidr: ZIO[Any, Nothing, Cidr] = ZIO.succeed(cidr)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.ReceiptIpFilter
  ) extends zio.aws.ses.model.ReceiptIpFilter.ReadOnly {
    override val policy: zio.aws.ses.model.ReceiptFilterPolicy =
      zio.aws.ses.model.ReceiptFilterPolicy.wrap(impl.policy())
    override val cidr: Cidr = zio.aws.ses.model.primitives.Cidr(impl.cidr())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.ReceiptIpFilter
  ): zio.aws.ses.model.ReceiptIpFilter.ReadOnly = new Wrapper(impl)
}
