package zio.aws.ses.model
import scala.jdk.CollectionConverters._
sealed trait SNSActionEncoding {
  def unwrap: software.amazon.awssdk.services.ses.model.SNSActionEncoding
}
object SNSActionEncoding {
  def wrap(
      value: software.amazon.awssdk.services.ses.model.SNSActionEncoding
  ): zio.aws.ses.model.SNSActionEncoding = value match {
    case software.amazon.awssdk.services.ses.model.SNSActionEncoding.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ses.model.SNSActionEncoding.UTF_8 =>
      val r = `UTF-8`
      r
    case software.amazon.awssdk.services.ses.model.SNSActionEncoding.BASE64 =>
      val r = Base64
      r
  }
  case object unknownToSdkVersion extends zio.aws.ses.model.SNSActionEncoding {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.SNSActionEncoding =
      software.amazon.awssdk.services.ses.model.SNSActionEncoding.UNKNOWN_TO_SDK_VERSION
  }
  case object `UTF-8` extends zio.aws.ses.model.SNSActionEncoding {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.SNSActionEncoding =
      software.amazon.awssdk.services.ses.model.SNSActionEncoding.UTF_8
  }
  case object Base64 extends zio.aws.ses.model.SNSActionEncoding {
    override def unwrap
        : software.amazon.awssdk.services.ses.model.SNSActionEncoding =
      software.amazon.awssdk.services.ses.model.SNSActionEncoding.BASE64
  }
}
