package zio.aws.ses.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateConfigurationSetRequest(
    configurationSet: zio.aws.ses.model.ConfigurationSet
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.CreateConfigurationSetRequest = {
    import CreateConfigurationSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.CreateConfigurationSetRequest
      .builder()
      .configurationSet(configurationSet.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.ses.model.CreateConfigurationSetRequest.ReadOnly =
    zio.aws.ses.model.CreateConfigurationSetRequest.wrap(buildAwsValue())
}
object CreateConfigurationSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.CreateConfigurationSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.CreateConfigurationSetRequest =
      zio.aws.ses.model
        .CreateConfigurationSetRequest(configurationSet.asEditable)
    def configurationSet: zio.aws.ses.model.ConfigurationSet.ReadOnly
    def getConfigurationSet
        : ZIO[Any, Nothing, zio.aws.ses.model.ConfigurationSet.ReadOnly] =
      ZIO.succeed(configurationSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.CreateConfigurationSetRequest
  ) extends zio.aws.ses.model.CreateConfigurationSetRequest.ReadOnly {
    override val configurationSet: zio.aws.ses.model.ConfigurationSet.ReadOnly =
      zio.aws.ses.model.ConfigurationSet.wrap(impl.configurationSet())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.CreateConfigurationSetRequest
  ): zio.aws.ses.model.CreateConfigurationSetRequest.ReadOnly = new Wrapper(
    impl
  )
}
