package zio.aws.ses.model
import zio.aws.ses.model.primitives.{EventDestinationName, ConfigurationSetName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteConfigurationSetEventDestinationRequest(
    configurationSetName: ConfigurationSetName,
    eventDestinationName: EventDestinationName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.DeleteConfigurationSetEventDestinationRequest = {
    import DeleteConfigurationSetEventDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.DeleteConfigurationSetEventDestinationRequest
      .builder()
      .configurationSetName(
        ConfigurationSetName.unwrap(configurationSetName): java.lang.String
      )
      .eventDestinationName(
        EventDestinationName.unwrap(eventDestinationName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ses.model.DeleteConfigurationSetEventDestinationRequest.ReadOnly =
    zio.aws.ses.model.DeleteConfigurationSetEventDestinationRequest
      .wrap(buildAwsValue())
}
object DeleteConfigurationSetEventDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.DeleteConfigurationSetEventDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ses.model.DeleteConfigurationSetEventDestinationRequest =
      zio.aws.ses.model.DeleteConfigurationSetEventDestinationRequest(
        configurationSetName,
        eventDestinationName
      )
    def configurationSetName: ConfigurationSetName
    def eventDestinationName: EventDestinationName
    def getConfigurationSetName: ZIO[Any, Nothing, ConfigurationSetName] =
      ZIO.succeed(configurationSetName)
    def getEventDestinationName: ZIO[Any, Nothing, EventDestinationName] =
      ZIO.succeed(eventDestinationName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.DeleteConfigurationSetEventDestinationRequest
  ) extends zio.aws.ses.model.DeleteConfigurationSetEventDestinationRequest.ReadOnly {
    override val configurationSetName: ConfigurationSetName =
      zio.aws.ses.model.primitives
        .ConfigurationSetName(impl.configurationSetName())
    override val eventDestinationName: EventDestinationName =
      zio.aws.ses.model.primitives
        .EventDestinationName(impl.eventDestinationName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.DeleteConfigurationSetEventDestinationRequest
  ): zio.aws.ses.model.DeleteConfigurationSetEventDestinationRequest.ReadOnly =
    new Wrapper(impl)
}
