package zio.aws.ses.model
import zio.aws.ses.model.primitives.Identity
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteIdentityRequest(identity: Identity) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.DeleteIdentityRequest = {
    import DeleteIdentityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.DeleteIdentityRequest
      .builder()
      .identity(Identity.unwrap(identity): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.DeleteIdentityRequest.ReadOnly =
    zio.aws.ses.model.DeleteIdentityRequest.wrap(buildAwsValue())
}
object DeleteIdentityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.DeleteIdentityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.DeleteIdentityRequest =
      zio.aws.ses.model.DeleteIdentityRequest(identity)
    def identity: Identity
    def getIdentity: ZIO[Any, Nothing, Identity] = ZIO.succeed(identity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.DeleteIdentityRequest
  ) extends zio.aws.ses.model.DeleteIdentityRequest.ReadOnly {
    override val identity: Identity =
      zio.aws.ses.model.primitives.Identity(impl.identity())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.DeleteIdentityRequest
  ): zio.aws.ses.model.DeleteIdentityRequest.ReadOnly = new Wrapper(impl)
}
