package zio.aws.ses.model
import zio.aws.ses.model.primitives.ReceiptRuleSetName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteReceiptRuleSetRequest(ruleSetName: ReceiptRuleSetName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.DeleteReceiptRuleSetRequest = {
    import DeleteReceiptRuleSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.DeleteReceiptRuleSetRequest
      .builder()
      .ruleSetName(ReceiptRuleSetName.unwrap(ruleSetName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.DeleteReceiptRuleSetRequest.ReadOnly =
    zio.aws.ses.model.DeleteReceiptRuleSetRequest.wrap(buildAwsValue())
}
object DeleteReceiptRuleSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.DeleteReceiptRuleSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.DeleteReceiptRuleSetRequest =
      zio.aws.ses.model.DeleteReceiptRuleSetRequest(ruleSetName)
    def ruleSetName: ReceiptRuleSetName
    def getRuleSetName: ZIO[Any, Nothing, ReceiptRuleSetName] =
      ZIO.succeed(ruleSetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.DeleteReceiptRuleSetRequest
  ) extends zio.aws.ses.model.DeleteReceiptRuleSetRequest.ReadOnly {
    override val ruleSetName: ReceiptRuleSetName =
      zio.aws.ses.model.primitives.ReceiptRuleSetName(impl.ruleSetName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.DeleteReceiptRuleSetRequest
  ): zio.aws.ses.model.DeleteReceiptRuleSetRequest.ReadOnly = new Wrapper(impl)
}
