package zio.aws.ses.model
import zio.aws.ses.model.primitives.MailFromDomainName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class IdentityMailFromDomainAttributes(
    mailFromDomain: MailFromDomainName,
    mailFromDomainStatus: zio.aws.ses.model.CustomMailFromStatus,
    behaviorOnMXFailure: zio.aws.ses.model.BehaviorOnMXFailure
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.IdentityMailFromDomainAttributes = {
    import IdentityMailFromDomainAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.IdentityMailFromDomainAttributes
      .builder()
      .mailFromDomain(
        MailFromDomainName.unwrap(mailFromDomain): java.lang.String
      )
      .mailFromDomainStatus(mailFromDomainStatus.unwrap)
      .behaviorOnMXFailure(behaviorOnMXFailure.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.IdentityMailFromDomainAttributes.ReadOnly =
    zio.aws.ses.model.IdentityMailFromDomainAttributes.wrap(buildAwsValue())
}
object IdentityMailFromDomainAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.IdentityMailFromDomainAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.IdentityMailFromDomainAttributes =
      zio.aws.ses.model.IdentityMailFromDomainAttributes(
        mailFromDomain,
        mailFromDomainStatus,
        behaviorOnMXFailure
      )
    def mailFromDomain: MailFromDomainName
    def mailFromDomainStatus: zio.aws.ses.model.CustomMailFromStatus
    def behaviorOnMXFailure: zio.aws.ses.model.BehaviorOnMXFailure
    def getMailFromDomain: ZIO[Any, Nothing, MailFromDomainName] =
      ZIO.succeed(mailFromDomain)
    def getMailFromDomainStatus
        : ZIO[Any, Nothing, zio.aws.ses.model.CustomMailFromStatus] =
      ZIO.succeed(mailFromDomainStatus)
    def getBehaviorOnMXFailure
        : ZIO[Any, Nothing, zio.aws.ses.model.BehaviorOnMXFailure] =
      ZIO.succeed(behaviorOnMXFailure)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.IdentityMailFromDomainAttributes
  ) extends zio.aws.ses.model.IdentityMailFromDomainAttributes.ReadOnly {
    override val mailFromDomain: MailFromDomainName =
      zio.aws.ses.model.primitives.MailFromDomainName(impl.mailFromDomain())
    override val mailFromDomainStatus: zio.aws.ses.model.CustomMailFromStatus =
      zio.aws.ses.model.CustomMailFromStatus.wrap(impl.mailFromDomainStatus())
    override val behaviorOnMXFailure: zio.aws.ses.model.BehaviorOnMXFailure =
      zio.aws.ses.model.BehaviorOnMXFailure.wrap(impl.behaviorOnMXFailure())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.IdentityMailFromDomainAttributes
  ): zio.aws.ses.model.IdentityMailFromDomainAttributes.ReadOnly = new Wrapper(
    impl
  )
}
