package zio.aws.ses
import zio.aws.ses.model.primitives.TemplateContent.Type
import java.time.Instant
import zio.Chunk
import zio.prelude.Subtype
import zio.aws.ses.model.primitives.{
  Identity,
  PolicyName,
  Recipient,
  Policy,
  Address,
  ReceiptRuleName,
  VerificationToken
}
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object Address extends Subtype[String]
    type Address = zio.aws.ses.model.primitives.Address.Type
    object AmazonResourceName extends Subtype[String]
    type AmazonResourceName =
      zio.aws.ses.model.primitives.AmazonResourceName.Type
    object ArrivalDate extends Subtype[Instant]
    type ArrivalDate = zio.aws.ses.model.primitives.ArrivalDate.Type
    object BounceMessage extends Subtype[String]
    type BounceMessage = zio.aws.ses.model.primitives.BounceMessage.Type
    object BounceSmtpReplyCode extends Subtype[String]
    type BounceSmtpReplyCode =
      zio.aws.ses.model.primitives.BounceSmtpReplyCode.Type
    object BounceStatusCode extends Subtype[String]
    type BounceStatusCode = zio.aws.ses.model.primitives.BounceStatusCode.Type
    object Charset extends Subtype[String]
    type Charset = zio.aws.ses.model.primitives.Charset.Type
    object Cidr extends Subtype[String]
    type Cidr = zio.aws.ses.model.primitives.Cidr.Type
    object ConfigurationSetName extends Subtype[String]
    type ConfigurationSetName =
      zio.aws.ses.model.primitives.ConfigurationSetName.Type
    object Counter extends Subtype[Long]
    type Counter = zio.aws.ses.model.primitives.Counter.Type
    object CustomRedirectDomain extends Subtype[String]
    type CustomRedirectDomain =
      zio.aws.ses.model.primitives.CustomRedirectDomain.Type
    object DefaultDimensionValue extends Subtype[String]
    type DefaultDimensionValue =
      zio.aws.ses.model.primitives.DefaultDimensionValue.Type
    object DiagnosticCode extends Subtype[String]
    type DiagnosticCode = zio.aws.ses.model.primitives.DiagnosticCode.Type
    object DimensionName extends Subtype[String]
    type DimensionName = zio.aws.ses.model.primitives.DimensionName.Type
    object Domain extends Subtype[String]
    type Domain = zio.aws.ses.model.primitives.Domain.Type
    object DsnStatus extends Subtype[String]
    type DsnStatus = zio.aws.ses.model.primitives.DsnStatus.Type
    object Enabled extends Subtype[Boolean]
    type Enabled = zio.aws.ses.model.primitives.Enabled.Type
    object Error extends Subtype[String]
    type Error = zio.aws.ses.model.primitives.Error.Type
    object EventDestinationName extends Subtype[String]
    type EventDestinationName =
      zio.aws.ses.model.primitives.EventDestinationName.Type
    object Explanation extends Subtype[String]
    type Explanation = zio.aws.ses.model.primitives.Explanation.Type
    object ExtensionFieldName extends Subtype[String]
    type ExtensionFieldName =
      zio.aws.ses.model.primitives.ExtensionFieldName.Type
    object ExtensionFieldValue extends Subtype[String]
    type ExtensionFieldValue =
      zio.aws.ses.model.primitives.ExtensionFieldValue.Type
    object FailureRedirectionURL extends Subtype[String]
    type FailureRedirectionURL =
      zio.aws.ses.model.primitives.FailureRedirectionURL.Type
    object FromAddress extends Subtype[String]
    type FromAddress = zio.aws.ses.model.primitives.FromAddress.Type
    object HeaderName extends Subtype[String]
    type HeaderName = zio.aws.ses.model.primitives.HeaderName.Type
    object HeaderValue extends Subtype[String]
    type HeaderValue = zio.aws.ses.model.primitives.HeaderValue.Type
    object HtmlPart extends Subtype[String]
    type HtmlPart = zio.aws.ses.model.primitives.HtmlPart.Type
    object Identity extends Subtype[String]
    type Identity = zio.aws.ses.model.primitives.Identity.Type
    object LastAttemptDate extends Subtype[Instant]
    type LastAttemptDate = zio.aws.ses.model.primitives.LastAttemptDate.Type
    object LastFreshStart extends Subtype[Instant]
    type LastFreshStart = zio.aws.ses.model.primitives.LastFreshStart.Type
    object MailFromDomainName extends Subtype[String]
    type MailFromDomainName =
      zio.aws.ses.model.primitives.MailFromDomainName.Type
    object Max24HourSend extends Subtype[Double]
    type Max24HourSend = zio.aws.ses.model.primitives.Max24HourSend.Type
    object MaxItems extends Subtype[Int]
    type MaxItems = zio.aws.ses.model.primitives.MaxItems.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.ses.model.primitives.MaxResults.Type
    object MaxSendRate extends Subtype[Double]
    type MaxSendRate = zio.aws.ses.model.primitives.MaxSendRate.Type
    object MessageData extends Subtype[String]
    type MessageData = zio.aws.ses.model.primitives.MessageData.Type
    object MessageId extends Subtype[String]
    type MessageId = zio.aws.ses.model.primitives.MessageId.Type
    object MessageTagName extends Subtype[String]
    type MessageTagName = zio.aws.ses.model.primitives.MessageTagName.Type
    object MessageTagValue extends Subtype[String]
    type MessageTagValue = zio.aws.ses.model.primitives.MessageTagValue.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.ses.model.primitives.NextToken.Type
    object NotificationTopic extends Subtype[String]
    type NotificationTopic = zio.aws.ses.model.primitives.NotificationTopic.Type
    object Policy extends Subtype[String]
    type Policy = zio.aws.ses.model.primitives.Policy.Type
    object PolicyName extends Subtype[String]
    type PolicyName = zio.aws.ses.model.primitives.PolicyName.Type
    object RawMessageData extends Subtype[Chunk[Byte]]
    type RawMessageData = zio.aws.ses.model.primitives.RawMessageData.Type
    object ReceiptFilterName extends Subtype[String]
    type ReceiptFilterName = zio.aws.ses.model.primitives.ReceiptFilterName.Type
    object ReceiptRuleName extends Subtype[String]
    type ReceiptRuleName = zio.aws.ses.model.primitives.ReceiptRuleName.Type
    object ReceiptRuleSetName extends Subtype[String]
    type ReceiptRuleSetName =
      zio.aws.ses.model.primitives.ReceiptRuleSetName.Type
    object Recipient extends Subtype[String]
    type Recipient = zio.aws.ses.model.primitives.Recipient.Type
    object RemoteMta extends Subtype[String]
    type RemoteMta = zio.aws.ses.model.primitives.RemoteMta.Type
    object RenderedTemplate extends Subtype[String]
    type RenderedTemplate = zio.aws.ses.model.primitives.RenderedTemplate.Type
    object ReportingMta extends Subtype[String]
    type ReportingMta = zio.aws.ses.model.primitives.ReportingMta.Type
    object S3BucketName extends Subtype[String]
    type S3BucketName = zio.aws.ses.model.primitives.S3BucketName.Type
    object S3KeyPrefix extends Subtype[String]
    type S3KeyPrefix = zio.aws.ses.model.primitives.S3KeyPrefix.Type
    object SentLast24Hours extends Subtype[Double]
    type SentLast24Hours = zio.aws.ses.model.primitives.SentLast24Hours.Type
    object Subject extends Subtype[String]
    type Subject = zio.aws.ses.model.primitives.Subject.Type
    object SubjectPart extends Subtype[String]
    type SubjectPart = zio.aws.ses.model.primitives.SubjectPart.Type
    object SuccessRedirectionURL extends Subtype[String]
    type SuccessRedirectionURL =
      zio.aws.ses.model.primitives.SuccessRedirectionURL.Type
    object TemplateContent extends Subtype[String]
    type TemplateContent = zio.aws.ses.model.primitives.TemplateContent.Type
    object TemplateData extends Subtype[String]
    type TemplateData = zio.aws.ses.model.primitives.TemplateData.Type
    object TemplateName extends Subtype[String]
    type TemplateName = zio.aws.ses.model.primitives.TemplateName.Type
    object TextPart extends Subtype[String]
    type TextPart = zio.aws.ses.model.primitives.TextPart.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.ses.model.primitives.Timestamp.Type
    object VerificationToken extends Subtype[String]
    type VerificationToken = zio.aws.ses.model.primitives.VerificationToken.Type
  }
  type AddressList = List[Address]
  type BouncedRecipientInfoList = List[zio.aws.ses.model.BouncedRecipientInfo]
  type BulkEmailDestinationList = List[zio.aws.ses.model.BulkEmailDestination]
  type BulkEmailDestinationStatusList =
    List[zio.aws.ses.model.BulkEmailDestinationStatus]
  type CloudWatchDimensionConfigurations =
    List[zio.aws.ses.model.CloudWatchDimensionConfiguration]
  type ConfigurationSetAttributeList =
    List[zio.aws.ses.model.ConfigurationSetAttribute]
  type ConfigurationSets = List[zio.aws.ses.model.ConfigurationSet]
  type CustomVerificationEmailTemplates =
    List[zio.aws.ses.model.CustomVerificationEmailTemplate]
  type DkimAttributes = Map[Identity, zio.aws.ses.model.IdentityDkimAttributes]
  type EventDestinations = List[zio.aws.ses.model.EventDestination]
  type EventTypes = List[zio.aws.ses.model.EventType]
  type ExtensionFieldList = List[zio.aws.ses.model.ExtensionField]
  type IdentityList = List[Identity]
  type MailFromDomainAttributes =
    Map[Identity, zio.aws.ses.model.IdentityMailFromDomainAttributes]
  type MessageTagList = List[zio.aws.ses.model.MessageTag]
  type NotificationAttributes =
    Map[Identity, zio.aws.ses.model.IdentityNotificationAttributes]
  type PolicyMap = Map[PolicyName, Policy]
  type PolicyNameList = List[PolicyName]
  type ReceiptActionsList = List[zio.aws.ses.model.ReceiptAction]
  type ReceiptFilterList = List[zio.aws.ses.model.ReceiptFilter]
  type ReceiptRuleNamesList = List[ReceiptRuleName]
  type ReceiptRuleSetsLists = List[zio.aws.ses.model.ReceiptRuleSetMetadata]
  type ReceiptRulesList = List[zio.aws.ses.model.ReceiptRule]
  type RecipientsList = List[Recipient]
  type SendDataPointList = List[zio.aws.ses.model.SendDataPoint]
  type TemplateMetadataList = List[zio.aws.ses.model.TemplateMetadata]
  type VerificationAttributes =
    Map[Identity, zio.aws.ses.model.IdentityVerificationAttributes]
  type VerificationTokenList = List[VerificationToken]
}
