package zio.aws.ses.model
import zio.aws.ses.model.primitives.ReceiptFilterName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteReceiptFilterRequest(filterName: ReceiptFilterName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.DeleteReceiptFilterRequest = {
    import DeleteReceiptFilterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.DeleteReceiptFilterRequest
      .builder()
      .filterName(ReceiptFilterName.unwrap(filterName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.DeleteReceiptFilterRequest.ReadOnly =
    zio.aws.ses.model.DeleteReceiptFilterRequest.wrap(buildAwsValue())
}
object DeleteReceiptFilterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.DeleteReceiptFilterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.DeleteReceiptFilterRequest =
      zio.aws.ses.model.DeleteReceiptFilterRequest(filterName)
    def filterName: ReceiptFilterName
    def getFilterName: ZIO[Any, Nothing, ReceiptFilterName] =
      ZIO.succeed(filterName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.DeleteReceiptFilterRequest
  ) extends zio.aws.ses.model.DeleteReceiptFilterRequest.ReadOnly {
    override val filterName: ReceiptFilterName =
      zio.aws.ses.model.primitives.ReceiptFilterName(impl.filterName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.DeleteReceiptFilterRequest
  ): zio.aws.ses.model.DeleteReceiptFilterRequest.ReadOnly = new Wrapper(impl)
}
