package zio.aws.ses.model
import scala.jdk.CollectionConverters._
sealed trait TlsPolicy {
  def unwrap: software.amazon.awssdk.services.ses.model.TlsPolicy
}
object TlsPolicy {
  def wrap(
      value: software.amazon.awssdk.services.ses.model.TlsPolicy
  ): zio.aws.ses.model.TlsPolicy = value match {
    case software.amazon.awssdk.services.ses.model.TlsPolicy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ses.model.TlsPolicy.REQUIRE =>
      val r = Require
      r
    case software.amazon.awssdk.services.ses.model.TlsPolicy.OPTIONAL =>
      val r = Optional
      r
  }
  case object unknownToSdkVersion extends zio.aws.ses.model.TlsPolicy {
    override def unwrap: software.amazon.awssdk.services.ses.model.TlsPolicy =
      software.amazon.awssdk.services.ses.model.TlsPolicy.UNKNOWN_TO_SDK_VERSION
  }
  case object Require extends zio.aws.ses.model.TlsPolicy {
    override def unwrap: software.amazon.awssdk.services.ses.model.TlsPolicy =
      software.amazon.awssdk.services.ses.model.TlsPolicy.REQUIRE
  }
  case object Optional extends zio.aws.ses.model.TlsPolicy {
    override def unwrap: software.amazon.awssdk.services.ses.model.TlsPolicy =
      software.amazon.awssdk.services.ses.model.TlsPolicy.OPTIONAL
  }
}
