package zio.aws.ses.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeReceiptRuleResponse(
    rule: Optional[zio.aws.ses.model.ReceiptRule] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.DescribeReceiptRuleResponse = {
    import DescribeReceiptRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.DescribeReceiptRuleResponse
      .builder()
      .optionallyWith(rule.map(value => value.buildAwsValue()))(_.rule)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.DescribeReceiptRuleResponse.ReadOnly =
    zio.aws.ses.model.DescribeReceiptRuleResponse.wrap(buildAwsValue())
}
object DescribeReceiptRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.DescribeReceiptRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.DescribeReceiptRuleResponse =
      zio.aws.ses.model
        .DescribeReceiptRuleResponse(rule.map(value => value.asEditable))
    def rule: Optional[zio.aws.ses.model.ReceiptRule.ReadOnly]
    def getRule: ZIO[Any, AwsError, zio.aws.ses.model.ReceiptRule.ReadOnly] =
      AwsError.unwrapOptionField("rule", rule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.DescribeReceiptRuleResponse
  ) extends zio.aws.ses.model.DescribeReceiptRuleResponse.ReadOnly {
    override val rule: Optional[zio.aws.ses.model.ReceiptRule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rule())
        .map(value => zio.aws.ses.model.ReceiptRule.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.DescribeReceiptRuleResponse
  ): zio.aws.ses.model.DescribeReceiptRuleResponse.ReadOnly = new Wrapper(impl)
}
