package zio.aws.ses.model
import zio.aws.ses.model.primitives.{
  TemplateData,
  ConfigurationSetName,
  TemplateName,
  AmazonResourceName,
  Address
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SendBulkTemplatedEmailRequest(
    source: Address,
    sourceArn: Optional[AmazonResourceName] = Optional.Absent,
    replyToAddresses: Optional[Iterable[Address]] = Optional.Absent,
    returnPath: Optional[Address] = Optional.Absent,
    returnPathArn: Optional[AmazonResourceName] = Optional.Absent,
    configurationSetName: Optional[ConfigurationSetName] = Optional.Absent,
    defaultTags: Optional[Iterable[zio.aws.ses.model.MessageTag]] =
      Optional.Absent,
    template: TemplateName,
    templateArn: Optional[AmazonResourceName] = Optional.Absent,
    defaultTemplateData: TemplateData,
    destinations: Iterable[zio.aws.ses.model.BulkEmailDestination]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ses.model.SendBulkTemplatedEmailRequest = {
    import SendBulkTemplatedEmailRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.SendBulkTemplatedEmailRequest
      .builder()
      .source(Address.unwrap(source): java.lang.String)
      .optionallyWith(
        sourceArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.sourceArn)
      .optionallyWith(
        replyToAddresses.map(value =>
          value.map { item =>
            Address.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.replyToAddresses)
      .optionallyWith(
        returnPath.map(value => Address.unwrap(value): java.lang.String)
      )(_.returnPath)
      .optionallyWith(
        returnPathArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.returnPathArn)
      .optionallyWith(
        configurationSetName.map(value =>
          ConfigurationSetName.unwrap(value): java.lang.String
        )
      )(_.configurationSetName)
      .optionallyWith(
        defaultTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.defaultTags)
      .template(TemplateName.unwrap(template): java.lang.String)
      .optionallyWith(
        templateArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.templateArn)
      .defaultTemplateData(
        TemplateData.unwrap(defaultTemplateData): java.lang.String
      )
      .destinations(destinations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.SendBulkTemplatedEmailRequest.ReadOnly =
    zio.aws.ses.model.SendBulkTemplatedEmailRequest.wrap(buildAwsValue())
}
object SendBulkTemplatedEmailRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ses.model.SendBulkTemplatedEmailRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.SendBulkTemplatedEmailRequest =
      zio.aws.ses.model.SendBulkTemplatedEmailRequest(
        source,
        sourceArn.map(value => value),
        replyToAddresses.map(value => value),
        returnPath.map(value => value),
        returnPathArn.map(value => value),
        configurationSetName.map(value => value),
        defaultTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        template,
        templateArn.map(value => value),
        defaultTemplateData,
        destinations.map { item =>
          item.asEditable
        }
      )
    def source: Address
    def sourceArn: Optional[AmazonResourceName]
    def replyToAddresses: Optional[List[Address]]
    def returnPath: Optional[Address]
    def returnPathArn: Optional[AmazonResourceName]
    def configurationSetName: Optional[ConfigurationSetName]
    def defaultTags: Optional[List[zio.aws.ses.model.MessageTag.ReadOnly]]
    def template: TemplateName
    def templateArn: Optional[AmazonResourceName]
    def defaultTemplateData: TemplateData
    def destinations: List[zio.aws.ses.model.BulkEmailDestination.ReadOnly]
    def getSource: ZIO[Any, Nothing, Address] = ZIO.succeed(source)
    def getSourceArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("sourceArn", sourceArn)
    def getReplyToAddresses: ZIO[Any, AwsError, List[Address]] =
      AwsError.unwrapOptionField("replyToAddresses", replyToAddresses)
    def getReturnPath: ZIO[Any, AwsError, Address] =
      AwsError.unwrapOptionField("returnPath", returnPath)
    def getReturnPathArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("returnPathArn", returnPathArn)
    def getConfigurationSetName: ZIO[Any, AwsError, ConfigurationSetName] =
      AwsError.unwrapOptionField("configurationSetName", configurationSetName)
    def getDefaultTags
        : ZIO[Any, AwsError, List[zio.aws.ses.model.MessageTag.ReadOnly]] =
      AwsError.unwrapOptionField("defaultTags", defaultTags)
    def getTemplate: ZIO[Any, Nothing, TemplateName] = ZIO.succeed(template)
    def getTemplateArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("templateArn", templateArn)
    def getDefaultTemplateData: ZIO[Any, Nothing, TemplateData] =
      ZIO.succeed(defaultTemplateData)
    def getDestinations: ZIO[Any, Nothing, List[
      zio.aws.ses.model.BulkEmailDestination.ReadOnly
    ]] = ZIO.succeed(destinations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.SendBulkTemplatedEmailRequest
  ) extends zio.aws.ses.model.SendBulkTemplatedEmailRequest.ReadOnly {
    override val source: Address =
      zio.aws.ses.model.primitives.Address(impl.source())
    override val sourceArn: Optional[AmazonResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceArn())
      .map(value => zio.aws.ses.model.primitives.AmazonResourceName(value))
    override val replyToAddresses: Optional[List[Address]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replyToAddresses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ses.model.primitives.Address(item)
          }.toList
        )
    override val returnPath: Optional[Address] = zio.aws.core.internal
      .optionalFromNullable(impl.returnPath())
      .map(value => zio.aws.ses.model.primitives.Address(value))
    override val returnPathArn: Optional[AmazonResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.returnPathArn())
        .map(value => zio.aws.ses.model.primitives.AmazonResourceName(value))
    override val configurationSetName: Optional[ConfigurationSetName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurationSetName())
        .map(value => zio.aws.ses.model.primitives.ConfigurationSetName(value))
    override val defaultTags
        : Optional[List[zio.aws.ses.model.MessageTag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ses.model.MessageTag.wrap(item)
          }.toList
        )
    override val template: TemplateName =
      zio.aws.ses.model.primitives.TemplateName(impl.template())
    override val templateArn: Optional[AmazonResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templateArn())
        .map(value => zio.aws.ses.model.primitives.AmazonResourceName(value))
    override val defaultTemplateData: TemplateData =
      zio.aws.ses.model.primitives.TemplateData(impl.defaultTemplateData())
    override val destinations
        : List[zio.aws.ses.model.BulkEmailDestination.ReadOnly] = impl
      .destinations()
      .asScala
      .map { item =>
        zio.aws.ses.model.BulkEmailDestination.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.SendBulkTemplatedEmailRequest
  ): zio.aws.ses.model.SendBulkTemplatedEmailRequest.ReadOnly = new Wrapper(
    impl
  )
}
