package zio.aws.ses.model
import zio.aws.ses.model.primitives.AmazonResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StopAction(
    scope: zio.aws.ses.model.StopScope,
    topicArn: Optional[AmazonResourceName] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ses.model.StopAction = {
    import StopAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ses.model.StopAction
      .builder()
      .scope(scope.unwrap)
      .optionallyWith(
        topicArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.topicArn)
      .build()
  }
  def asReadOnly: zio.aws.ses.model.StopAction.ReadOnly =
    zio.aws.ses.model.StopAction.wrap(buildAwsValue())
}
object StopAction {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ses.model.StopAction] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ses.model.StopAction =
      zio.aws.ses.model.StopAction(scope, topicArn.map(value => value))
    def scope: zio.aws.ses.model.StopScope
    def topicArn: Optional[AmazonResourceName]
    def getScope: ZIO[Any, Nothing, zio.aws.ses.model.StopScope] =
      ZIO.succeed(scope)
    def getTopicArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("topicArn", topicArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ses.model.StopAction
  ) extends zio.aws.ses.model.StopAction.ReadOnly {
    override val scope: zio.aws.ses.model.StopScope =
      zio.aws.ses.model.StopScope.wrap(impl.scope())
    override val topicArn: Optional[AmazonResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.topicArn())
      .map(value => zio.aws.ses.model.primitives.AmazonResourceName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ses.model.StopAction
  ): zio.aws.ses.model.StopAction.ReadOnly = new Wrapper(impl)
}
